/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class AbstractBundle
implements Bundle,
Comparable,
KeyedElement {
    protected Framework framework;
    protected volatile int state = 2;
    protected volatile Thread stateChanging = null;
    protected BundleData bundledata;
    protected Object statechangeLock = new Object();
    protected BundleProtectionDomain domain;
    protected ManifestLocalization manifestLocalization = null;

    protected static AbstractBundle createBundle(BundleData bundledata, Framework framework) throws BundleException {
        if ((bundledata.getType() & 1) > 0) {
            return new BundleFragment(bundledata, framework);
        }
        return new BundleHost(bundledata, framework);
    }

    protected AbstractBundle(BundleData bundledata, Framework framework) {
        this.bundledata = bundledata;
        this.framework = framework;
        bundledata.setBundle(this);
    }

    protected abstract void load();

    protected abstract boolean reload(AbstractBundle var1);

    protected abstract void refresh();

    protected abstract boolean unload();

    protected void close() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.close called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.state = 1;
    }

    protected BundleActivator loadBundleActivator() throws BundleException {
        String activatorClassName = this.bundledata.getActivator();
        if (activatorClassName != null) {
            try {
                Class activatorClass = this.loadClass(activatorClassName, false);
                return (BundleActivator)activatorClass.newInstance();
            }
            catch (Throwable t) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(t);
                }
                throw new BundleException(NLS.bind(Msg.BUNDLE_INVALID_ACTIVATOR_EXCEPTION, activatorClassName, this.bundledata.getSymbolicName()), t);
            }
        }
        return null;
    }

    protected abstract Class loadClass(String var1, boolean var2) throws ClassNotFoundException;

    public int getState() {
        return this.state;
    }

    protected boolean isActive() {
        return (this.state & 0x28) != 0;
    }

    protected boolean isResolved() {
        return (this.state & 3) == 0;
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        this.framework.checkAdminPermission(this, "execute");
        this.checkValid();
        this.beginStateChange();
        try {
            this.startWorker(options);
        }
        finally {
            this.completeStateChange();
        }
    }

    protected abstract void startWorker(int var1) throws BundleException;

    protected boolean readyToResume() {
        return false;
    }

    protected void resume() throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            if (this.readyToResume()) {
                this.startWorker(1);
            }
        }
        finally {
            this.completeStateChange();
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        this.framework.checkAdminPermission(this, "execute");
        this.checkValid();
        this.beginStateChange();
        try {
            this.stopWorker(options);
        }
        finally {
            this.completeStateChange();
        }
    }

    protected abstract void stopWorker(int var1) throws BundleException;

    protected void setStatus(final int mask, final boolean state) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException, IOException {
                    boolean test;
                    int status = AbstractBundle.this.bundledata.getStatus();
                    boolean bl = test = (status & mask) != 0;
                    if (test != state) {
                        AbstractBundle.this.bundledata.setStatus(state ? status | mask : status & ~mask);
                        AbstractBundle.this.bundledata.save();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            this.framework.publishFrameworkEvent(2, this, pae.getException());
        }
    }

    protected void suspend(boolean lock) throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            this.stopWorker(1);
        }
        finally {
            if (!lock) {
                this.completeStateChange();
            }
        }
    }

    public void update() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.bundledata.getLocation());
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 6) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            final AccessControlContext callerContext = AccessController.getContext();
            this.updateWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    String updateLocation = AbstractBundle.this.bundledata.getLocation();
                    if (AbstractBundle.this.bundledata.getManifest().get("Bundle-UpdateLocation") != null) {
                        updateLocation = (String)AbstractBundle.this.bundledata.getManifest().get("Bundle-UpdateLocation");
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println("   from location: " + updateLocation);
                        }
                    }
                    URLConnection source = AbstractBundle.this.framework.adaptor.mapLocationToURLConnection(updateLocation);
                    AbstractBundle.this.updateWorkerPrivileged(source, callerContext);
                    return null;
                }
            });
        }
        finally {
            this.completeStateChange();
        }
    }

    public void update(final InputStream in) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("update location " + this.bundledata.getLocation());
            Debug.println("   from: " + in);
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 6) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            final AccessControlContext callerContext = AccessController.getContext();
            this.updateWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    BundleSource source = new BundleSource(in);
                    AbstractBundle.this.updateWorkerPrivileged(source, callerContext);
                    return null;
                }
            });
        }
        finally {
            this.completeStateChange();
        }
    }

    protected void updateWorker(PrivilegedExceptionAction action) throws BundleException {
        boolean bundleActive;
        block15: {
            bundleActive = false;
            if (!this.isFragment()) {
                boolean bl = bundleActive = (this.state & 0x28) != 0;
            }
            if (bundleActive) {
                try {
                    this.stopWorker(1);
                }
                catch (BundleException e) {
                    this.framework.publishFrameworkEvent(2, this, e);
                    if ((this.state & 0x28) == 0) break block15;
                    throw e;
                }
            }
        }
        try {
            try {
                AccessController.doPrivileged(action);
                this.framework.publishBundleEvent(8, this);
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof RuntimeException) {
                    throw (RuntimeException)pae.getException();
                }
                throw (BundleException)pae.getException();
            }
        }
        finally {
            if (bundleActive) {
                try {
                    this.startWorker(1);
                }
                catch (BundleException e) {
                    this.framework.publishFrameworkEvent(2, this, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWorkerPrivileged(URLConnection source, AccessControlContext callerContext) throws BundleException {
        AbstractBundle oldBundle = AbstractBundle.createBundle(this.bundledata, this.framework);
        boolean reloaded = false;
        BundleOperation storage = this.framework.adaptor.updateBundle(this.bundledata, source);
        BundleRepository bundles = this.framework.getBundles();
        try {
            boolean exporting;
            BundleData newBundleData = storage.begin();
            final AbstractBundle newBundle = this.framework.createAndVerifyBundle(newBundleData);
            String[] nativepaths = this.framework.selectNativeCode(newBundle);
            if (nativepaths != null) {
                this.bundledata.installNativeCode(nativepaths);
            }
            int st = this.getState();
            BundleRepository bundleRepository = bundles;
            synchronized (bundleRepository) {
                exporting = this.reload(newBundle);
                this.manifestLocalization = null;
            }
            reloaded = true;
            if (System.getSecurityManager() != null) {
                boolean extension;
                boolean bl = extension = (this.bundledata.getType() & 6) != 0;
                if (extension && !this.hasPermission(new AllPermission())) {
                    throw new BundleException(Msg.BUNDLE_EXTENSION_PERMISSION, new SecurityException(Msg.BUNDLE_EXTENSION_PERMISSION));
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            AbstractBundle.this.framework.checkAdminPermission(newBundle, "lifecycle");
                            if (extension) {
                                AbstractBundle.this.framework.checkAdminPermission(newBundle, "extensionLifecycle");
                            }
                            return null;
                        }
                    }, callerContext);
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            if (st == 4) {
                this.framework.publishBundleEvent(64, this);
            }
            storage.commit(exporting);
        }
        catch (Throwable t) {
            block18: {
                try {
                    storage.undo();
                    if (!reloaded) break block18;
                    BundleRepository newBundle = bundles;
                    synchronized (newBundle) {
                        this.reload(oldBundle);
                    }
                }
                catch (BundleException ee) {
                    this.framework.publishFrameworkEvent(2, this, ee);
                }
            }
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof BundleException) {
                throw (BundleException)t;
            }
            throw new BundleException(t.getMessage(), t);
        }
    }

    public void uninstall() throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("uninstall location: " + this.bundledata.getLocation());
        }
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.bundledata.getType() & 6) != 0) {
            this.framework.checkAdminPermission(this, "extensionLifecycle");
        }
        this.checkValid();
        this.beginStateChange();
        try {
            this.uninstallWorker(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    AbstractBundle.this.uninstallWorkerPrivileged();
                    return null;
                }
            });
        }
        finally {
            this.completeStateChange();
        }
    }

    protected void uninstallWorker(PrivilegedExceptionAction action) throws BundleException {
        boolean bundleActive = false;
        if (!this.isFragment()) {
            boolean bl = bundleActive = (this.state & 0x28) != 0;
        }
        if (bundleActive) {
            try {
                this.stopWorker(1);
            }
            catch (BundleException e) {
                this.framework.publishFrameworkEvent(2, this, e);
            }
        }
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            if (bundleActive) {
                try {
                    this.startWorker(1);
                }
                catch (BundleException e) {
                    this.framework.publishFrameworkEvent(2, this, e);
                }
            }
            throw (BundleException)pae.getException();
        }
        this.framework.publishBundleEvent(16, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallWorkerPrivileged() throws BundleException {
        BundleWatcher bundleStats = this.framework.adaptor.getBundleWatcher();
        if (bundleStats != null) {
            bundleStats.watchBundle(this, 64);
        }
        boolean unloaded = false;
        this.getHeaders();
        BundleOperation storage = this.framework.adaptor.uninstallBundle(this.bundledata);
        BundleRepository bundles = this.framework.getBundles();
        try {
            try {
                boolean exporting;
                storage.begin();
                int st = this.getState();
                BundleRepository bundleRepository = bundles;
                synchronized (bundleRepository) {
                    bundles.remove(this);
                    exporting = this.unload();
                }
                if (st == 4) {
                    this.framework.publishBundleEvent(64, this);
                }
                unloaded = true;
                storage.commit(exporting);
                this.close();
            }
            catch (BundleException e) {
                block17: {
                    try {
                        storage.undo();
                        if (!unloaded) break block17;
                        BundleRepository st = bundles;
                        synchronized (st) {
                            this.load();
                            bundles.add(this);
                        }
                    }
                    catch (BundleException ee) {
                        this.framework.publishFrameworkEvent(2, this, ee);
                    }
                }
                throw e;
            }
        }
        finally {
            BundleWatcher bundleStats2 = this.framework.adaptor.getBundleWatcher();
            if (bundleStats2 != null) {
                bundleStats2.watchBundle(this, 128);
            }
        }
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String localeString) {
        this.framework.checkAdminPermission(this, "metadata");
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException e) {
            this.framework.publishFrameworkEvent(2, this, e);
            return new Hashtable();
        }
        if (localeString == null) {
            localeString = Locale.getDefault().toString();
        }
        return this.manifestLocalization.getHeaders(localeString);
    }

    public long getBundleId() {
        return this.bundledata.getBundleID();
    }

    public String getLocation() {
        this.framework.checkAdminPermission(this, "metadata");
        return this.bundledata.getLocation();
    }

    public boolean hasPermission(Object permission) {
        this.checkValid();
        if (this.domain != null) {
            if (permission instanceof Permission) {
                SecurityManager sm = System.getSecurityManager();
                if (sm instanceof FrameworkSecurityManager) {
                    AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{this.domain});
                    try {
                        sm.checkPermission((Permission)permission, acc);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return this.domain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    protected void beginStateChange() throws BundleException {
        Object object = this.statechangeLock;
        synchronized (object) {
            boolean doubleFault = false;
            while (true) {
                if (this.stateChanging == null) {
                    this.stateChanging = Thread.currentThread();
                    return;
                }
                if (doubleFault || this.stateChanging == Thread.currentThread()) {
                    throw new BundleException(NLS.bind(Msg.BUNDLE_STATE_CHANGE_EXCEPTION, this.getBundleData().getLocation(), this.stateChanging.getName()), new BundleStatusException(null, 4, this.stateChanging));
                }
                try {
                    long end;
                    long start = 0L;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(" Waiting for state to change in bundle " + this);
                        start = System.currentTimeMillis();
                    }
                    this.statechangeLock.wait(5000L);
                    if (Debug.DEBUG_GENERAL && (end = System.currentTimeMillis()) - start > 0L) {
                        System.out.println("Waiting... : " + this.getSymbolicName() + ' ' + (end - start));
                    }
                }
                catch (InterruptedException interruptedException) {}
                doubleFault = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeStateChange() {
        Object object = this.statechangeLock;
        synchronized (object) {
            if (this.stateChanging != null) {
                this.stateChanging = null;
                this.statechangeLock.notify();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.bundledata.getLocation()) + " [" + this.getBundleId() + "]";
    }

    public int compareTo(Object obj) {
        int slcomp = this.getStartLevel() - ((AbstractBundle)obj).getStartLevel();
        if (slcomp != 0) {
            return slcomp;
        }
        long idcomp = this.getBundleId() - ((AbstractBundle)obj).getBundleId();
        return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
    }

    protected void checkValid() {
        if (this.state == 1) {
            throw new IllegalStateException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
    }

    protected BundleProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    protected void unresolvePermissions() {
        if (this.domain != null) {
            BundlePermissionCollection collection = (BundlePermissionCollection)this.domain.getPermissions();
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unresolving permissions in bundle " + this);
            }
            collection.unresolvePermissions();
        }
    }

    protected Bundle[] getFragments() {
        this.checkValid();
        return null;
    }

    protected boolean isFragment() {
        return false;
    }

    protected BundleLoaderProxy[] getHosts() {
        this.checkValid();
        return null;
    }

    public Class loadClass(String classname) throws ClassNotFoundException {
        return this.loadClass(classname, true);
    }

    public Enumeration getEntryPaths(final String path) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AbstractBundle.this.bundledata.getEntryPaths(path);
            }
        });
    }

    public URL getEntry(String fileName) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (System.getSecurityManager() == null) {
            return this.bundledata.getEntry(fileName);
        }
        final String ffileName = fileName;
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AbstractBundle.this.bundledata.getEntry(ffileName);
            }
        });
    }

    public String getSymbolicName() {
        return this.bundledata.getSymbolicName();
    }

    public long getLastModified() {
        return this.bundledata.getLastModified();
    }

    public BundleData getBundleData() {
        return this.bundledata;
    }

    public Version getVersion() {
        return this.bundledata.getVersion();
    }

    protected BundleDescription getBundleDescription() {
        return this.framework.adaptor.getState().getBundle(this.getBundleId());
    }

    protected int getStartLevel() {
        return this.bundledata.getStartLevel();
    }

    protected abstract BundleLoader getBundleLoader();

    protected void resolve() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.resolve called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 2) {
            this.state = 4;
        }
    }

    public BundleContext getBundleContext() {
        this.framework.checkAdminPermission(this, "context");
        return this.getContext();
    }

    protected abstract BundleContextImpl getContext();

    public String getResolutionFailureMessage() {
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return Msg.BUNDLE_UNRESOLVED_EXCEPTION;
        }
        if (bundleDescription.isResolved()) {
            throw new IllegalStateException(Msg.BUNDLE_UNRESOLVED_STATE_CONFLICT);
        }
        return NLS.bind(Msg.BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION, this.getResolverError(bundleDescription));
    }

    private String getResolverError(BundleDescription bundleDesc) {
        ResolverError[] errors = this.framework.adaptor.getState().getResolverErrors(bundleDesc);
        if (errors == null || errors.length == 0) {
            return Msg.BUNDLE_UNRESOLVED_EXCEPTION;
        }
        StringBuffer message = new StringBuffer();
        int i = 0;
        while (i < errors.length) {
            message.append(errors[i].toString());
            if (i < errors.length - 1) {
                message.append(", ");
            }
            ++i;
        }
        return message.toString();
    }

    public int getKeyHashCode() {
        return (int)this.getBundleId();
    }

    public boolean compare(KeyedElement other) {
        return this.getBundleId() == ((AbstractBundle)other).getBundleId();
    }

    public Object getKey() {
        return new Long(this.getBundleId());
    }

    public ResourceBundle getResourceBundle(String localeString) {
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException bundleException) {
            return null;
        }
        if (localeString == null) {
            localeString = Locale.getDefault().toString();
        }
        return this.manifestLocalization.getResourceBundle(localeString);
    }

    private void initializeManifestLocalization() throws BundleException {
        if (this.manifestLocalization == null) {
            Dictionary rawHeaders = this.bundledata.getManifest();
            this.manifestLocalization = new ManifestLocalization(this, rawHeaders);
        }
    }

    public boolean testStateChanging(Object thread) {
        return this.stateChanging == thread;
    }

    public Thread getStateChanging() {
        return this.stateChanging;
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (!this.isResolved()) {
            this.framework.packageAdmin.resolveBundles(new Bundle[]{this});
        }
        ArrayList pathList = new ArrayList();
        FilterImpl patternFilter = null;
        Hashtable patternProps = null;
        if (filePattern != null) {
            try {
                patternFilter = new FilterImpl("(filename=" + filePattern + ")");
                patternProps = new Hashtable(2);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        this.findLocalEntryPaths(path, patternFilter, patternProps, recurse, pathList);
        final Bundle[] fragments = this.getFragments();
        final int numFragments = fragments == null ? -1 : fragments.length;
        int i = 0;
        while (i < numFragments) {
            ((AbstractBundle)fragments[i]).findLocalEntryPaths(path, patternFilter, patternProps, recurse, pathList);
            ++i;
        }
        if (pathList.size() == 0) {
            return null;
        }
        final String[] pathArray = pathList.toArray(new String[pathList.size()]);
        return new Enumeration(){
            int curIndex = 0;
            int curFragment = -1;
            URL nextElement = null;

            public boolean hasMoreElements() {
                if (this.nextElement != null) {
                    return true;
                }
                this.getNextElement();
                return this.nextElement != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                URL result = this.nextElement;
                this.getNextElement();
                return result;
            }

            private void getNextElement() {
                this.nextElement = null;
                if (this.curIndex >= pathArray.length) {
                    return;
                }
                String curPath = pathArray[this.curIndex];
                if (this.curFragment == -1) {
                    this.nextElement = AbstractBundle.this.getEntry(curPath);
                    ++this.curFragment;
                }
                while (this.nextElement == null && this.curFragment < numFragments) {
                    this.nextElement = fragments[this.curFragment++].getEntry(curPath);
                }
                if (numFragments == -1 || this.curFragment >= numFragments) {
                    ++this.curIndex;
                    this.curFragment = -1;
                }
                if (this.nextElement == null) {
                    this.getNextElement();
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected void findLocalEntryPaths(String path, Filter patternFilter, Hashtable patternProps, boolean recurse, List pathList) {
        entryPaths = this.bundledata.getEntryPaths(path);
        if (entryPaths != null) ** GOTO lbl25
        return;
lbl-1000:
        // 1 sources

        {
            entry = (String)entryPaths.nextElement();
            lastSlash = entry.lastIndexOf(47);
            if (patternProps != null) {
                secondToLastSlash = entry.lastIndexOf(47, lastSlash - 1);
                fileEnd = entry.length();
                if (lastSlash < 0) {
                    fileStart = 0;
                } else if (lastSlash != entry.length() - 1) {
                    fileStart = lastSlash + 1;
                } else {
                    fileEnd = lastSlash;
                    fileStart = secondToLastSlash < 0 ? 0 : secondToLastSlash + 1;
                }
                fileName = entry.substring(fileStart, fileEnd);
                patternProps.put("filename", fileName);
            }
            if (!pathList.contains(entry) && (patternFilter == null || patternFilter.matchCase(patternProps))) {
                pathList.add(entry);
            }
            if (!recurse || entry.equals(path) || entry.length() <= 0 || lastSlash != entry.length() - 1) continue;
            this.findLocalEntryPaths(entry, patternFilter, patternProps, recurse, pathList);
lbl25:
            // 3 sources

            ** while (entryPaths.hasMoreElements())
        }
lbl26:
        // 1 sources

    }

    class BundleStatusException
    extends Throwable
    implements StatusException {
        private static final long serialVersionUID = 7201911791818929100L;
        private int code;
        private Object status;

        BundleStatusException(String message, int code, Object status) {
            super(message);
            this.code = code;
            this.status = status;
        }

        public Object getStatus() {
            return this.status;
        }

        public int getStatusCode() {
            return this.code;
        }
    }
}

