/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private FileUtils() {
    }

    public static synchronized File getDefaultTempDir() {
        File f;
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = null;
        try {
            s = System.getProperty(FileUtils.class.getName() + ".TempDirectory");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (s != null && (f = new File(s)).mkdirs()) {
            defaultTempDir = f;
        }
        if (defaultTempDir == null) {
            int x = (int)(Math.random() * 1000000.0);
            s = System.getProperty("java.io.tmpdir");
            File checkExists = new File(s);
            if (!checkExists.exists() || !checkExists.isDirectory()) {
                throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
            }
            if (!checkExists.canWrite()) {
                throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " is now writable, please set java.io.tempdir" + " to an writable directory");
            }
            File f2 = new File(s, "cxf-tmp-" + x);
            while (!f2.mkdir()) {
                x = (int)(Math.random() * 1000000.0);
                f2 = new File(s, "cxf-tmp-" + x);
            }
            defaultTempDir = f2;
            final File f22 = f2;
            Thread hook = new Thread(){

                public void run() {
                    FileUtils.removeDir(f22, true);
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        }
        return defaultTempDir;
    }

    public static void mkDir(File dir) {
        boolean result;
        if (dir == null) {
            throw new RuntimeException("dir attribute is required");
        }
        if (dir.isFile()) {
            throw new RuntimeException("Unable to create directory as a file already exists with that name: " + dir.getAbsolutePath());
        }
        if (!dir.exists() && !(result = FileUtils.doMkDirs(dir))) {
            String msg = "Directory " + dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new RuntimeException(msg);
        }
    }

    private static boolean doMkDirs(File f) {
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f.mkdirs();
            }
            catch (InterruptedException ex) {
                return f.mkdirs();
            }
        }
        return true;
    }

    public static void removeDir(File d) {
        FileUtils.removeDir(d, false);
    }

    private static void removeDir(File d, boolean inShutdown) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtils.removeDir(f, inShutdown);
                continue;
            }
            FileUtils.delete(f, inShutdown);
        }
        FileUtils.delete(d, inShutdown);
    }

    public static void delete(File f) {
        FileUtils.delete(f, false);
    }

    public static void delete(File f, boolean inShutdown) {
        if (!f.delete()) {
            if (FileUtils.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete() && !inShutdown) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFile(prefix, suffix, null, false);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir, boolean deleteOnExit) throws IOException {
        File parent;
        File result = null;
        File file = parent = parentDir == null ? FileUtils.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "cxf";
        } else if (prefix.length() < 3) {
            prefix = prefix + "cxf";
        }
        result = File.createTempFile(prefix, suffix, parent);
        if (deleteOnExit && parentDir != null) {
            result.deleteOnExit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStringFromFile(File location) {
        FileInputStream is = null;
        String result = null;
        is = new FileInputStream(location);
        result = FileUtils.normalizeCRLF(is);
        Object var5_3 = null;
        if (is == null) return result;
        try {
            ((InputStream)is).close();
            return result;
        }
        catch (Exception e2) {}
        return result;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var5_4 = null;
                if (is == null) return result;
                try {
                    ((InputStream)is).close();
                    return result;
                }
                catch (Exception e2) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String normalizeCRLF(InputStream instream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(instream));
        StringBuilder result = new StringBuilder();
        String line = null;
        try {
            line = in.readLine();
            while (line != null) {
                String[] tok = line.split("\\s");
                for (int x = 0; x < tok.length; ++x) {
                    String token = tok[x];
                    result.append("  " + token);
                }
                line = in.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String rtn = result.toString();
        rtn = FileUtils.ignoreTokens(rtn, "<!--", "-->");
        rtn = FileUtils.ignoreTokens(rtn, "/*", "*/");
        return rtn;
    }

    private static String ignoreTokens(String contents, String startToken, String endToken) {
        String rtn = contents;
        int headerIndexStart = rtn.indexOf(startToken);
        int headerIndexEnd = rtn.indexOf(endToken);
        if (headerIndexStart != -1 && headerIndexEnd != -1 && headerIndexStart < headerIndexEnd) {
            rtn = rtn.substring(0, headerIndexStart - 1) + rtn.substring(headerIndexEnd + endToken.length() + 1);
        }
        return rtn;
    }

    public static List<File> getFiles(File dir, String pattern) {
        return FileUtils.getFiles(dir, pattern, null);
    }

    public static List<File> getFilesRecurse(File dir, String pattern) {
        return FileUtils.getFilesRecurse(dir, pattern, null);
    }

    public static List<File> getFiles(File dir, String pattern, File exclude) {
        return FileUtils.getFilesRecurse(dir, Pattern.compile(pattern), exclude, false, new ArrayList<File>());
    }

    public static List<File> getFilesRecurse(File dir, String pattern, File exclude) {
        return FileUtils.getFilesRecurse(dir, Pattern.compile(pattern), exclude, true, new ArrayList<File>());
    }

    private static List<File> getFilesRecurse(File dir, Pattern pattern, File exclude, boolean rec, List<File> fileList) {
        for (File file : dir.listFiles()) {
            if (file.equals(exclude)) continue;
            if (file.isDirectory() && rec) {
                FileUtils.getFilesRecurse(file, pattern, exclude, rec, fileList);
                continue;
            }
            Matcher m = pattern.matcher(file.getName());
            if (!m.matches()) continue;
            fileList.add(file);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws Exception {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> results = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                results.add(line);
                line = reader.readLine();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return results;
    }
}

