/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/html"})
public class SourceProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Source> {
    private static final String PREFERRED_FORMAT = "source-preferred-format";
    @Context
    private MessageContext context;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Source.class.isAssignableFrom(type);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return Source.class.isAssignableFrom(type) || XMLSource.class.isAssignableFrom(type) || Document.class.isAssignableFrom(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readFrom(Class<Object> source, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        String s;
        Class<Object> theSource = source;
        if (theSource == Source.class && ("sax".equalsIgnoreCase(s = this.getPreferredSource()) || "cxf.stax".equalsIgnoreCase(s))) {
            theSource = SAXSource.class;
        }
        if (DOMSource.class.isAssignableFrom(theSource) || Document.class.isAssignableFrom(theSource)) {
            Object object;
            boolean docRequired = Document.class.isAssignableFrom(theSource);
            XMLStreamReader reader = this.getReader(is);
            try {
                try {
                    Document doc = StaxUtils.read(reader);
                    object = docRequired ? doc : new DOMSource(doc);
                    Object var13_15 = null;
                }
                catch (Exception e) {
                    IOException ioex = new IOException("Problem creating a Source object");
                    ioex.setStackTrace(e.getStackTrace());
                    throw ioex;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (XMLStreamException e2) {
                // empty catch block
                return object;
            }
            reader.close();
            return object;
        }
        if (SAXSource.class.isAssignableFrom(theSource)) return new StaxSource(this.getReader(is));
        if (StaxSource.class.isAssignableFrom(theSource)) {
            return new StaxSource(this.getReader(is));
        }
        if (StreamSource.class.isAssignableFrom(theSource)) return new StreamSource(this.getRealStream(is));
        if (Source.class.isAssignableFrom(theSource)) {
            return new StreamSource(this.getRealStream(is));
        }
        if (!XMLSource.class.isAssignableFrom(theSource)) throw new IOException("Unrecognized source");
        return new XMLSource(this.getRealStream(is));
    }

    protected XMLStreamReader getReader(InputStream is) {
        XMLStreamReader reader = this.getReaderFromMessage();
        return reader == null ? StaxUtils.createXMLStreamReader(is) : reader;
    }

    protected InputStream getRealStream(InputStream is) throws IOException {
        XMLStreamReader reader = this.getReaderFromMessage();
        return reader == null ? is : this.getStreamFromReader(reader);
    }

    private InputStream getStreamFromReader(XMLStreamReader input) throws IOException {
        InputStream inputStream;
        CachedOutputStream out = new CachedOutputStream();
        try {
            StaxUtils.copy(input, (OutputStream)out);
            inputStream = out.getInputStream();
            Object var5_5 = null;
        }
        catch (XMLStreamException ex) {
            try {
                throw new IOException("XMLStreamException:" + ex.getMessage());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                out.close();
                throw throwable;
            }
        }
        out.close();
        return inputStream;
    }

    protected XMLStreamReader getReaderFromMessage() {
        MessageContext mc = this.getContext();
        if (mc != null) {
            return mc.getContent(XMLStreamReader.class);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public void writeTo(Source source, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        block11: {
            String encoding = HttpUtils.getSetEncoding(mt, headers, "UTF-8");
            XMLStreamReader reader = StaxUtils.createXMLStreamReader(source);
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(os, encoding);
            StaxUtils.copy(reader, writer);
            Object var13_11 = null;
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            try {
                writer.flush();
            }
            catch (XMLStreamException e) {}
            break block11;
            {
                catch (XMLStreamException e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    // empty catch block
                }
                try {
                    writer.flush();
                }
                catch (XMLStreamException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public long getSize(Source source, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected String getPreferredSource() {
        MessageContext mc = this.getContext();
        if (mc != null) {
            return (String)mc.getContextualProperty(PREFERRED_FORMAT);
        }
        return "sax";
    }

    protected MessageContext getContext() {
        return this.context;
    }
}

