/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.transform.DelegatingNamespaceContext;
import org.apache.cxf.staxutils.transform.QNamesMap;
import org.apache.cxf.staxutils.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutTransformWriter
extends DelegatingXMLStreamWriter {
    private String defaultNamespace;
    private QNamesMap elementsMap;
    private Map<QName, QName> appendMap = new HashMap<QName, QName>(5);
    private Map<String, String> nsMap = new HashMap<String, String>(5);
    private Set<String> writtenUris = new HashSet<String>(2);
    private Set<QName> dropElements;
    private List<Integer> droppingIndexes = new LinkedList<Integer>();
    private List<QName> appendedElements = new LinkedList<QName>();
    private List<Integer> appendedIndexes = new LinkedList<Integer>();
    private int currentDepth;
    private boolean attributesToElements;
    private DelegatingNamespaceContext namespaceContext;

    public OutTransformWriter(XMLStreamWriter writer, Map<String, String> outMap, Map<String, String> append, List<String> dropEls, boolean attributesToElements, String defaultNamespace) {
        super(writer);
        this.elementsMap = new QNamesMap(outMap == null ? 0 : outMap.size());
        TransformUtils.convertToQNamesMap(outMap, this.elementsMap, this.nsMap);
        TransformUtils.convertToMapOfQNames(append, this.appendMap);
        this.dropElements = XMLUtils.convertStringsToQNames(dropEls);
        this.attributesToElements = attributesToElements;
        this.namespaceContext = new DelegatingNamespaceContext(writer.getNamespaceContext(), this.nsMap);
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public void writeNamespace(String prefix, String uri) throws XMLStreamException {
        if (this.matchesDropped()) {
            return;
        }
        String value = this.nsMap.get(uri);
        if (value != null && value.length() == 0) {
            return;
        }
        String string = uri = value != null ? value : uri;
        if (this.writtenUris.contains(uri)) {
            return;
        }
        if (this.defaultNamespace != null && this.defaultNamespace.equals(uri)) {
            super.writeDefaultNamespace(uri);
        } else {
            if (prefix.length() == 0) {
                prefix = this.namespaceContext.findUniquePrefix(uri);
            }
            super.writeNamespace(prefix, uri);
        }
        this.writtenUris.add(uri);
    }

    @Override
    public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
        ++this.currentDepth;
        QName currentQName = new QName(uri, local);
        QName appendQName = this.appendMap.get(currentQName);
        if (appendQName != null && !this.appendedElements.contains(appendQName)) {
            ++this.currentDepth;
            String theprefix = uri.equals(appendQName.getNamespaceURI()) ? prefix : "";
            this.write(new QName(appendQName.getNamespaceURI(), appendQName.getLocalPart(), theprefix));
            if (theprefix.length() > 0) {
                this.writeNamespace(theprefix, uri);
            }
            this.appendedElements.add(appendQName);
            this.appendedIndexes.add(this.currentDepth - 1);
        }
        if (this.dropElements.contains(currentQName)) {
            this.droppingIndexes.add(this.currentDepth - 1);
            return;
        }
        this.write(new QName(uri, local, prefix));
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.currentDepth;
        if (this.indexRemoved(this.droppingIndexes)) {
            return;
        }
        super.writeEndElement();
        if (this.indexRemoved(this.appendedIndexes)) {
            super.writeEndElement();
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (this.matchesDropped()) {
            return;
        }
        super.writeCharacters(text);
    }

    private void write(QName qname) throws XMLStreamException {
        QName name = this.elementsMap.get(qname);
        if (name == null) {
            name = qname;
        }
        boolean writeNs = false;
        String prefix = "";
        if (name.getNamespaceURI().length() > 0) {
            if (qname.getPrefix().length() == 0) {
                prefix = this.namespaceContext.findUniquePrefix(name.getNamespaceURI());
                writeNs = true;
            } else {
                prefix = qname.getPrefix();
                this.namespaceContext.addPrefix(prefix, qname.getNamespaceURI());
            }
        }
        if (this.defaultNamespace != null && this.defaultNamespace.equals(name.getNamespaceURI())) {
            prefix = "";
        }
        super.writeStartElement(prefix, name.getLocalPart(), name.getNamespaceURI());
        if (writeNs) {
            this.writeNamespace(prefix, name.getNamespaceURI());
        }
    }

    private boolean matchesDropped() {
        int size = this.droppingIndexes.size();
        return size > 0 && this.droppingIndexes.get(size - 1) == this.currentDepth - 1;
    }

    private boolean indexRemoved(List<Integer> indexes) {
        int size = indexes.size();
        if (size > 0 && indexes.get(size - 1) == this.currentDepth) {
            indexes.remove(size - 1);
            return true;
        }
        return false;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public void writeAttribute(String uri, String local, String value) throws XMLStreamException {
        if (!this.attributesToElements) {
            super.writeAttribute(uri, local, value);
        } else {
            this.writeAttributeAsElement(uri, local, value);
        }
    }

    @Override
    public void writeAttribute(String local, String value) throws XMLStreamException {
        if (!this.attributesToElements) {
            super.writeAttribute(local, value);
        } else {
            this.writeAttributeAsElement("", local, value);
        }
    }

    private void writeAttributeAsElement(String uri, String local, String value) throws XMLStreamException {
        this.writeStartElement(uri, local);
        this.writeCharacters(value);
        this.writeEndElement();
    }
}

