/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.kerberos.KerberosClient;
import org.apache.cxf.ws.security.kerberos.KerberosUtils;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.policyvalidators.KerberosTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;

public class KerberosTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    public KerberosTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.KERBEROS_TOKEN, SP12Constants.KERBEROS_TOKEN));
        this.getOutInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getOutFaultInterceptors().add(PolicyBasedWSS4JOutInterceptor.INSTANCE);
        this.getInInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getInFaultInterceptors().add(PolicyBasedWSS4JInInterceptor.INSTANCE);
        this.getOutInterceptors().add(new KerberosTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new KerberosTokenOutInterceptor());
        this.getInInterceptors().add(new KerberosTokenInInterceptor());
        this.getInFaultInterceptors().add(new KerberosTokenInInterceptor());
    }

    static final TokenStore getTokenStore(Message message) {
        TokenStore tokenStore = (TokenStore)message.getContextualProperty(TokenStore.class.getName());
        if (tokenStore == null) {
            tokenStore = new MemoryTokenStore();
            ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)tokenStore);
        }
        return tokenStore;
    }

    private static SecurityToken createSecurityToken(BinarySecurity binarySecurityToken) {
        SecurityToken token = new SecurityToken(binarySecurityToken.getID());
        token.setToken(binarySecurityToken.getElement());
        token.setSecret(binarySecurityToken.getToken());
        token.setTokenType(binarySecurityToken.getValueType());
        return token;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KerberosTokenInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public KerberosTokenInInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
            this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get((Object)SP12Constants.KERBEROS_TOKEN);
                if (ais == null) {
                    return;
                }
                if (!this.isRequestor(message)) {
                    List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                    if (results != null) {
                        this.parseHandlerResults(results, message, aim);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }

        private void parseHandlerResults(List<WSHandlerResult> results, Message message, AssertionInfoMap aim) {
            if (results != null) {
                for (WSHandlerResult rResult : results) {
                    List<KerberosSecurity> kerberosResults = this.findKerberosResults(rResult.getResults());
                    Iterator<KerberosSecurity> i$ = kerberosResults.iterator();
                    while (i$.hasNext()) {
                        KerberosTokenPolicyValidator kerberosValidator = new KerberosTokenPolicyValidator(message);
                        KerberosSecurity kerberosToken = i$.next();
                        boolean valid = kerberosValidator.validatePolicy(aim, kerberosToken);
                        if (!valid) continue;
                        SecurityToken token = KerberosTokenInterceptorProvider.createSecurityToken((BinarySecurity)kerberosToken);
                        message.getExchange().put((Object)"ws-security.token", (Object)token);
                        return;
                    }
                }
            }
        }

        private List<KerberosSecurity> findKerberosResults(List<WSSecurityEngineResult> wsSecEngineResults) {
            ArrayList<KerberosSecurity> results = new ArrayList<KerberosSecurity>();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                BinarySecurity binarySecurity;
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 4096 || !((binarySecurity = (BinarySecurity)wser.get((Object)"binary-security-token")) instanceof KerberosSecurity)) continue;
                results.add((KerberosSecurity)binarySecurity);
            }
            return results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KerberosTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public KerberosTokenOutInterceptor() {
            super("prepare-send");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null) {
                Collection ais = (Collection)aim.get((Object)SP12Constants.KERBEROS_TOKEN);
                if (ais == null || ais.isEmpty()) {
                    return;
                }
                if (this.isRequestor(message)) {
                    String tokId;
                    SecurityToken tok = (SecurityToken)message.getContextualProperty("ws-security.token");
                    if (tok == null && (tokId = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                        tok = KerberosTokenInterceptorProvider.getTokenStore(message).getToken(tokId);
                    }
                    if (tok == null) {
                        try {
                            KerberosClient client;
                            KerberosClient kerberosClient = client = KerberosUtils.getClient(message, "kerberos");
                            synchronized (kerberosClient) {
                                tok = client.requestSecurityToken();
                            }
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new Fault((Throwable)e);
                        }
                    }
                    if (tok != null) {
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token.id", (Object)tok.getId());
                        message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getId());
                        KerberosTokenInterceptorProvider.getTokenStore(message).add(tok);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
            }
        }
    }
}

