/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AsymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.neethi.Assertion;
import org.apache.ws.security.WSSecurityEngineResult;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsymmetricBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        boolean hasDerivedKeys = false;
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt != 2048) continue;
            hasDerivedKeys = true;
            break;
        }
        for (AssertionInfo ai : ais) {
            AsymmetricBinding binding = (AsymmetricBinding)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.checkProtectionOrder(binding, ai, results)) {
                return false;
            }
            if (!this.checkProperties(binding, ai, aim, results, signedResults, message)) {
                return false;
            }
            if (this.checkTokens(binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTokens(AsymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim, boolean hasDerivedKeys, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        if (binding.getInitiatorToken() != null) {
            Token token = binding.getInitiatorToken().getToken();
            if (token instanceof X509Token) {
                boolean foundCert = false;
                for (WSSecurityEngineResult result : signedResults) {
                    X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
                    if (cert == null) continue;
                    foundCert = true;
                    break;
                }
                if (!foundCert && !signedResults.isEmpty()) {
                    String error = "An X.509 certificate was not used for the initiator token";
                    this.notAssertPolicy(aim, binding.getInitiatorToken().getName(), error);
                    ai.setNotAsserted(error);
                    return false;
                }
            }
            this.assertPolicy(aim, (Assertion)binding.getInitiatorToken());
            if (!this.checkDerivedKeys(binding.getInitiatorToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
        }
        if (binding.getRecipientToken() != null) {
            this.assertPolicy(aim, (Assertion)binding.getRecipientToken());
            if (!this.checkDerivedKeys(binding.getRecipientToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
        }
        return true;
    }
}

