/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.TokenStream;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.collections.AST;
import java.io.File;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.HashMap;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.corba.common.Processor;
import org.apache.cxf.tools.corba.common.ProcessorEnvironment;
import org.apache.cxf.tools.corba.idlpreprocessor.DefaultIncludeResolver;
import org.apache.cxf.tools.corba.idlpreprocessor.DefineState;
import org.apache.cxf.tools.corba.idlpreprocessor.IdlPreprocessorReader;
import org.apache.cxf.tools.corba.processors.idl.IDLLexer;
import org.apache.cxf.tools.corba.processors.idl.IDLParser;

public class IDLProcessor
implements Processor {
    protected ProcessorEnvironment env;
    protected IdlPreprocessorReader preprocessor;
    private IDLParser parser;

    public void setEnvironment(ProcessorEnvironment penv) {
        this.env = penv;
    }

    public void process() throws ToolException {
        String location = this.env.get("idl").toString();
        File file = new File(location).getAbsoluteFile();
        if (!file.exists()) {
            throw new ToolException("IDL file " + file.getName() + " doesn't exist");
        }
        try {
            URL orig = file.toURI().toURL();
            DefaultIncludeResolver includeResolver = this.getDefaultIncludeResolver(file.getParentFile());
            DefineState defineState = new DefineState(new HashMap<String, String>());
            this.preprocessor = new IdlPreprocessorReader(orig, location, includeResolver, defineState);
            IDLLexer lexer = new IDLLexer(new LineNumberReader(this.preprocessor));
            lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
            TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
            filter.discard(106);
            filter.hide(108);
            filter.hide(109);
            this.parser = new IDLParser((TokenStream)filter);
            this.parser.setASTNodeClass("antlr.CommonASTWithHiddenTokens");
            this.parser.specification();
        }
        catch (Exception ex) {
            throw new ToolException((Throwable)ex);
        }
    }

    public AST getIDLTree() {
        if (this.parser != null) {
            return this.parser.getAST();
        }
        return null;
    }

    private DefaultIncludeResolver getDefaultIncludeResolver(File currentDir) {
        DefaultIncludeResolver includeResolver;
        if (this.env.optionSet("includedir")) {
            String[] includedDirs = (String[])this.env.get("includedir");
            File[] includeDirs = new File[includedDirs.length];
            for (int i = 0; i < includedDirs.length; ++i) {
                includeDirs[i] = new File(includedDirs[i]);
            }
            includeResolver = new DefaultIncludeResolver(includeDirs);
        } else {
            includeResolver = new DefaultIncludeResolver(currentDir);
        }
        return includeResolver;
    }
}

