/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.cxf.ws.security.policy.model.ContentEncryptedElements;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.RequiredElements;
import org.apache.cxf.ws.security.policy.model.RequiredParts;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.Wss11;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.CryptoCoverageUtil;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSupportingTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AsymmetricBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.EncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.EndorsingEncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.EndorsingTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SamlTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SecurityContextTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedEncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedEndorsingEncryptedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedEndorsingTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SignedTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SymmetricBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TransportBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.UsernameTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.WSS11PolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.X509TokenPolicyValidator;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyBasedWSS4JInInterceptor
extends WSS4JInInterceptor {
    public static final String PROPERTIES_CACHE = "ws-security.properties.cache";
    public static final PolicyBasedWSS4JInInterceptor INSTANCE = new PolicyBasedWSS4JInInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyBasedWSS4JInInterceptor.class);

    public PolicyBasedWSS4JInInterceptor() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Object, Properties> getPropertiesCache(SoapMessage message) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
        synchronized (endpointInfo) {
            Map<Object, Properties> o = CastUtils.cast((Map)message.getContextualProperty(PROPERTIES_CACHE));
            if (o == null) {
                o = new ConcurrentHashMap();
                info.setProperty(PROPERTIES_CACHE, o);
            }
            return o;
        }
    }

    private static Properties getProps(Object o, String propsKey, URL propsURL, SoapMessage message) {
        Properties properties = PolicyBasedWSS4JInInterceptor.getPropertiesCache(message).get(propsKey);
        if (properties != null) {
            return properties;
        }
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (propsURL != null) {
            try {
                properties = new Properties();
                InputStream ins = propsURL.openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                properties = null;
            }
        }
        if (properties != null) {
            PolicyBasedWSS4JInInterceptor.getPropertiesCache(message).put(propsKey, properties);
        }
        return properties;
    }

    private URL getPropertiesFileURL(Object o, SoapMessage message) {
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = message.getExchange().get(Bus.class).getExtension(ResourceManager.class);
            url = rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)o, AbstractWSS4JInterceptor.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException e) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    private void handleWSS11(AssertionInfoMap aim, SoapMessage message) {
        if (this.isRequestor(message)) {
            message.put("enableSignatureConfirmation", (Object)"false");
            Collection ais = (Collection)aim.get(SP12Constants.WSS11);
            if (ais != null) {
                for (AssertionInfo ai : ais) {
                    Wss11 wss11 = (Wss11)ai.getAssertion();
                    if (!wss11.isRequireSignatureConfirmation()) continue;
                    message.put("enableSignatureConfirmation", (Object)"true");
                    break;
                }
            }
        }
    }

    private String addToAction(String action, String val, boolean pre) {
        if (action.contains(val)) {
            return action;
        }
        if (pre) {
            return val + " " + action;
        }
        return action + " " + val;
    }

    private boolean assertPolicy(AssertionInfoMap aim, QName q) {
        Collection ais = (Collection)aim.get(q);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    private String checkAsymmetricBinding(AssertionInfoMap aim, String action, SoapMessage message) {
        String propsKey;
        URL propsURL;
        Object e;
        Collection ais = (Collection)aim.get(SP12Constants.ASYMMETRIC_BINDING);
        if (ais == null || ais.isEmpty()) {
            return action;
        }
        action = this.addToAction(action, "Signature", true);
        action = this.addToAction(action, "Encrypt", true);
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        if (s != null) {
            propsURL = this.getPropertiesFileURL(s, message);
            propsKey = s.toString();
            if (propsURL != null) {
                propsKey = propsURL.getPath();
            }
            message.put("decryptionPropRefId", (Object)("RefId-" + propsKey));
            if (s instanceof Crypto) {
                message.put("RefId-" + propsKey, (Object)((Crypto)s));
            } else {
                message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(s, propsKey, propsURL, message));
            }
            if (e == null) {
                e = s;
            }
        }
        if (e != null) {
            propsURL = this.getPropertiesFileURL(e, message);
            propsKey = e.toString();
            if (propsURL != null) {
                propsKey = propsURL.getPath();
            }
            message.put("signaturePropRefId", (Object)("RefId-" + propsKey));
            if (e instanceof Crypto) {
                message.put("RefId-" + propsKey, (Object)((Crypto)e));
            } else {
                message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(e, propsKey, propsURL, message));
            }
        }
        return action;
    }

    private String checkTransportBinding(AssertionInfoMap aim, String action, SoapMessage message) {
        String propsKey;
        URL propsURL;
        Object e;
        Collection ais = (Collection)aim.get(SP12Constants.TRANSPORT_BINDING);
        if (ais == null || ais.isEmpty()) {
            return action;
        }
        action = this.addToAction(action, "Signature", true);
        action = this.addToAction(action, "Encrypt", true);
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        if (s != null) {
            propsURL = this.getPropertiesFileURL(s, message);
            propsKey = s.toString();
            if (propsURL != null) {
                propsKey = propsURL.getPath();
            }
            message.put("decryptionPropRefId", (Object)("RefId-" + propsKey));
            if (s instanceof Crypto) {
                message.put("RefId-" + propsKey, (Object)((Crypto)s));
            } else {
                message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(s, propsKey, propsURL, message));
            }
            if (e == null) {
                e = s;
            }
        }
        if (e != null) {
            propsURL = this.getPropertiesFileURL(e, message);
            propsKey = e.toString();
            if (propsURL != null) {
                propsKey = propsURL.getPath();
            }
            message.put("signaturePropRefId", (Object)("RefId-" + propsKey));
            if (e instanceof Crypto) {
                message.put("RefId-" + propsKey, (Object)((Crypto)e));
            } else {
                message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(e, propsKey, propsURL, message));
            }
        }
        return action;
    }

    private String checkSymmetricBinding(AssertionInfoMap aim, String action, SoapMessage message) {
        Object e;
        Collection ais = (Collection)aim.get(SP12Constants.SYMMETRIC_BINDING);
        if (ais == null || ais.isEmpty()) {
            return action;
        }
        action = this.addToAction(action, "Signature", true);
        action = this.addToAction(action, "Encrypt", true);
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        if (e != null && s == null) {
            s = e;
        } else if (s != null && e == null) {
            e = s;
        }
        if (this.isRequestor(message)) {
            String propsKey;
            URL propsURL;
            if (e != null) {
                propsURL = this.getPropertiesFileURL(e, message);
                propsKey = e.toString();
                if (propsURL != null) {
                    propsKey = propsURL.getPath();
                }
                message.put("signaturePropRefId", (Object)("RefId-" + propsKey));
                if (e instanceof Crypto) {
                    message.put("RefId-" + propsKey, (Object)((Crypto)e));
                } else {
                    message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(e, propsKey, propsURL, message));
                }
            }
            if (s != null) {
                propsURL = this.getPropertiesFileURL(s, message);
                propsKey = s.toString();
                if (propsURL != null) {
                    propsKey = propsURL.getPath();
                }
                message.put("decryptionPropRefId", (Object)("RefId-" + propsKey));
                if (s instanceof Crypto) {
                    message.put("RefId-" + propsKey, (Object)((Crypto)s));
                } else {
                    message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(s, propsKey, propsURL, message));
                }
            }
        } else {
            String propsKey;
            URL propsURL;
            if (s != null) {
                propsURL = this.getPropertiesFileURL(s, message);
                propsKey = s.toString();
                if (propsURL != null) {
                    propsKey = propsURL.getPath();
                }
                message.put("signaturePropRefId", (Object)("RefId-" + propsKey));
                if (s instanceof Crypto) {
                    message.put("RefId-" + propsKey, (Object)((Crypto)s));
                } else {
                    message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(s, propsKey, propsURL, message));
                }
            }
            if (e != null) {
                propsURL = this.getPropertiesFileURL(e, message);
                propsKey = e.toString();
                if (propsURL != null) {
                    propsKey = propsURL.getPath();
                }
                message.put("decryptionPropRefId", (Object)("RefId-" + propsKey));
                if (e instanceof Crypto) {
                    message.put("RefId-" + propsKey, (Object)((Crypto)e));
                } else {
                    message.put("RefId-" + propsKey, (Object)PolicyBasedWSS4JInInterceptor.getProps(e, propsKey, propsURL, message));
                }
            }
        }
        return action;
    }

    private boolean assertXPathTokens(AssertionInfoMap aim, QName name, Collection<WSDataRef> refs, SoapMessage msg, Element soapEnvelope, CryptoCoverageUtil.CoverageType type, CryptoCoverageUtil.CoverageScope scope) throws SOAPException {
        Collection ais = (Collection)aim.get(name);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                AbstractSecurityAssertion p;
                ai.setAsserted(true);
                Map<String, String> namespaces = null;
                List<String> xpaths = null;
                if (CryptoCoverageUtil.CoverageScope.CONTENT.equals((Object)scope)) {
                    p = (ContentEncryptedElements)ai.getAssertion();
                    namespaces = ((ContentEncryptedElements)p).getDeclaredNamespaces();
                    xpaths = ((ContentEncryptedElements)p).getXPathExpressions();
                } else {
                    p = (SignedEncryptedElements)ai.getAssertion();
                    namespaces = ((SignedEncryptedElements)p).getDeclaredNamespaces();
                    xpaths = ((SignedEncryptedElements)p).getXPathExpressions();
                }
                if (xpaths == null) continue;
                for (String xPath : xpaths) {
                    try {
                        CryptoCoverageUtil.checkCoverage(soapEnvelope, refs, namespaces, xPath, type, scope);
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted("No " + (Object)((Object)type) + " element found matching XPath " + xPath);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean assertTokens(AssertionInfoMap aim, QName name, Collection<WSDataRef> signed, SoapMessage msg, Element soapHeader, Element soapBody, CryptoCoverageUtil.CoverageType type) throws SOAPException {
        Collection ais = (Collection)aim.get(name);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
                SignedEncryptedParts p = (SignedEncryptedParts)ai.getAssertion();
                if (p.isBody()) {
                    try {
                        if (CryptoCoverageUtil.CoverageType.SIGNED.equals((Object)type)) {
                            CryptoCoverageUtil.checkBodyCoverage(soapBody, signed, type, CryptoCoverageUtil.CoverageScope.ELEMENT);
                        } else {
                            CryptoCoverageUtil.checkBodyCoverage(soapBody, signed, type, CryptoCoverageUtil.CoverageScope.CONTENT);
                        }
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted(msg.getVersion().getBody() + " not " + (Object)((Object)type));
                        return false;
                    }
                }
                for (Header h : p.getHeaders()) {
                    try {
                        CryptoCoverageUtil.checkHeaderCoverage(soapHeader, signed, h.getNamespace(), h.getName(), type, CryptoCoverageUtil.CoverageScope.ELEMENT);
                    }
                    catch (WSSecurityException e) {
                        ai.setNotAsserted(h.getQName() + " not + " + (Object)((Object)type));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected void computeAction(SoapMessage message, RequestData data) {
        AssertionInfoMap aim;
        String action = this.getString("action", message);
        if (action == null) {
            action = "";
        }
        if ((aim = message.get(AssertionInfoMap.class)) != null) {
            this.handleWSS11(aim, message);
            action = this.checkAsymmetricBinding(aim, action, message);
            action = this.checkSymmetricBinding(aim, action, message);
            action = this.checkTransportBinding(aim, action, message);
            this.assertPolicy(aim, SP12Constants.KEYVALUE_TOKEN);
            message.put("action", (Object)action.trim());
        }
    }

    @Override
    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> results, boolean utWithCallbacks) throws SOAPException, XMLStreamException, WSSecurityException {
        AssertionInfoMap aim = msg.get(AssertionInfoMap.class);
        HashSet<WSDataRef> signed = new HashSet<WSDataRef>();
        HashSet<WSDataRef> encrypted = new HashSet<WSDataRef>();
        ArrayList<WSSecurityEngineResult> signedResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)2, signedResults);
        WSSecurityUtil.fetchAllActionResults(results, (int)64, signedResults);
        for (WSSecurityEngineResult result : signedResults) {
            List<WSDataRef> sl = CastUtils.cast((List)result.get((Object)"data-ref-uris"));
            if (sl == null) continue;
            for (WSDataRef r : sl) {
                signed.add(r);
            }
        }
        ArrayList<WSSecurityEngineResult> encryptResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)4, encryptResults);
        for (WSSecurityEngineResult result : encryptResults) {
            List<WSDataRef> sl = CastUtils.cast((List)result.get((Object)"data-ref-uris"));
            if (sl == null) continue;
            for (WSDataRef r : sl) {
                encrypted.add(r);
            }
        }
        if (!this.checkSignedEncryptedCoverage(aim, msg, soapHeader, soapBody, signed, encrypted)) {
            LOG.fine("Incoming request failed signed-encrypted policy validation");
        }
        if (!this.checkTokenCoverage(aim, msg, soapBody, results, signedResults)) {
            LOG.fine("Incoming request failed token policy validation");
        }
        if (!this.checkBindingCoverage(aim, msg, soapBody, results, signedResults, encryptResults)) {
            LOG.fine("Incoming request failed binding policy validation");
        }
        if (!this.checkSupportingTokenCoverage(aim, msg, results, signedResults, encryptResults, utWithCallbacks)) {
            LOG.fine("Incoming request failed supporting token policy validation");
        }
        this.assertPolicy(aim, SP12Constants.SUPPORTING_TOKENS);
        this.assertPolicy(aim, SP12Constants.LAYOUT);
        this.assertPolicy(aim, SP12Constants.WSS10);
        this.assertPolicy(aim, SP12Constants.TRUST_13);
        this.assertPolicy(aim, SP11Constants.TRUST_10);
        super.doResults(msg, actor, soapHeader, soapBody, results, utWithCallbacks);
    }

    private boolean checkSignedEncryptedCoverage(AssertionInfoMap aim, SoapMessage msg, Element soapHeader, Element soapBody, Collection<WSDataRef> signed, Collection<WSDataRef> encrypted) throws SOAPException {
        CryptoCoverageUtil.reconcileEncryptedSignedRefs(signed, encrypted);
        boolean check = true;
        if (!this.isTransportBinding(aim)) {
            check &= this.assertTokens(aim, SP12Constants.SIGNED_PARTS, signed, msg, soapHeader, soapBody, CryptoCoverageUtil.CoverageType.SIGNED);
            check &= this.assertTokens(aim, SP12Constants.ENCRYPTED_PARTS, encrypted, msg, soapHeader, soapBody, CryptoCoverageUtil.CoverageType.ENCRYPTED);
        }
        Element soapEnvelope = soapHeader.getOwnerDocument().getDocumentElement();
        check &= this.assertXPathTokens(aim, SP12Constants.SIGNED_ELEMENTS, signed, msg, soapEnvelope, CryptoCoverageUtil.CoverageType.SIGNED, CryptoCoverageUtil.CoverageScope.ELEMENT);
        check &= this.assertXPathTokens(aim, SP12Constants.ENCRYPTED_ELEMENTS, encrypted, msg, soapEnvelope, CryptoCoverageUtil.CoverageType.ENCRYPTED, CryptoCoverageUtil.CoverageScope.ELEMENT);
        check &= this.assertXPathTokens(aim, SP12Constants.CONTENT_ENCRYPTED_ELEMENTS, encrypted, msg, soapEnvelope, CryptoCoverageUtil.CoverageType.ENCRYPTED, CryptoCoverageUtil.CoverageScope.CONTENT);
        return check &= this.assertHeadersExists(aim, msg, soapHeader);
    }

    private boolean checkTokenCoverage(AssertionInfoMap aim, SoapMessage msg, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        boolean check = true;
        X509TokenPolicyValidator x509Validator = new X509TokenPolicyValidator();
        check &= x509Validator.validatePolicy(aim, msg, soapBody, results, signedResults);
        UsernameTokenPolicyValidator utValidator = new UsernameTokenPolicyValidator();
        check &= utValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
        SamlTokenPolicyValidator samlValidator = new SamlTokenPolicyValidator();
        check &= samlValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
        SecurityContextTokenPolicyValidator sctValidator = new SecurityContextTokenPolicyValidator();
        check &= sctValidator.validatePolicy(aim, msg, soapBody, results, signedResults);
        WSS11PolicyValidator wss11Validator = new WSS11PolicyValidator();
        return check &= wss11Validator.validatePolicy(aim, msg, soapBody, results, signedResults);
    }

    private boolean checkBindingCoverage(AssertionInfoMap aim, SoapMessage msg, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        boolean check = true;
        TransportBindingPolicyValidator transportValidator = new TransportBindingPolicyValidator();
        check &= transportValidator.validatePolicy(aim, msg, soapBody, results, signedResults, encryptedResults);
        SymmetricBindingPolicyValidator symmetricValidator = new SymmetricBindingPolicyValidator();
        check &= symmetricValidator.validatePolicy(aim, msg, soapBody, results, signedResults, encryptedResults);
        AsymmetricBindingPolicyValidator asymmetricValidator = new AsymmetricBindingPolicyValidator();
        return check &= asymmetricValidator.validatePolicy(aim, msg, soapBody, results, signedResults, encryptedResults);
    }

    private boolean checkSupportingTokenCoverage(AssertionInfoMap aim, SoapMessage msg, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults, boolean utWithCallbacks) {
        ArrayList<WSSecurityEngineResult> utResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)1, utResults);
        WSSecurityUtil.fetchAllActionResults(results, (int)8192, utResults);
        ArrayList<WSSecurityEngineResult> samlResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)16, samlResults);
        WSSecurityUtil.fetchAllActionResults(results, (int)8, samlResults);
        WSSecurityEngineResult tsResult = WSSecurityUtil.fetchActionResult(results, (int)32);
        Element timestamp = null;
        if (tsResult != null) {
            Timestamp ts = (Timestamp)tsResult.get((Object)"timestamp");
            timestamp = ts.getElement();
        }
        boolean check = true;
        AbstractSupportingTokenPolicyValidator validator = new SignedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new EndorsingTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new SignedEndorsingTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new SignedEncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new EncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new EndorsingEncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
        validator = new SignedEndorsingEncryptedTokenPolicyValidator();
        validator.setUsernameTokenResults(utResults, utWithCallbacks);
        validator.setSAMLTokenResults(samlResults);
        validator.setTimestampElement(timestamp);
        return check &= validator.validatePolicy(aim, msg, results, signedResults, encryptedResults);
    }

    private boolean assertHeadersExists(AssertionInfoMap aim, SoapMessage msg, Node header) throws SOAPException {
        AbstractSecurityAssertion rp;
        Collection ais = (Collection)aim.get(SP12Constants.REQUIRED_PARTS);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                rp = (RequiredParts)ai.getAssertion();
                ai.setAsserted(true);
                for (Header h : ((RequiredParts)rp).getHeaders()) {
                    if (header != null && DOMUtils.getFirstChildWithName((Element)header, h.getQName()) != null) continue;
                    ai.setNotAsserted("No header element of name " + h.getQName() + " found.");
                    return false;
                }
            }
        }
        if ((ais = (Collection)aim.get(SP12Constants.REQUIRED_ELEMENTS)) != null) {
            for (AssertionInfo ai : ais) {
                rp = (RequiredElements)ai.getAssertion();
                ai.setAsserted(true);
                Map<String, String> namespaces = ((RequiredElements)rp).getDeclaredNamespaces();
                XPathFactory factory = XPathFactory.newInstance();
                for (String expression : ((RequiredElements)rp).getXPathExpressions()) {
                    XPath xpath = factory.newXPath();
                    if (namespaces != null) {
                        xpath.setNamespaceContext(new MapNamespaceContext(namespaces));
                    }
                    try {
                        NodeList list = (NodeList)xpath.evaluate(expression, header, XPathConstants.NODESET);
                        if (list.getLength() != 0) continue;
                        ai.setNotAsserted("No header element matching XPath " + expression + " found.");
                        return false;
                    }
                    catch (XPathExpressionException e) {
                        ai.setNotAsserted("Invalid XPath expression " + expression + " " + e.getMessage());
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isTransportBinding(AssertionInfoMap aim) {
        Collection ais = (Collection)aim.get(SP12Constants.TRANSPORT_BINDING);
        if (ais != null && ais.size() > 0) {
            ais = (Collection)aim.get(SP12Constants.SYMMETRIC_BINDING);
            if (ais != null && ais.size() > 0) {
                return false;
            }
            ais = (Collection)aim.get(SP12Constants.ASYMMETRIC_BINDING);
            return ais == null || ais.size() <= 0;
        }
        return false;
    }
}

