/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public IssuedTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        IssuedToken issuedToken = new IssuedToken(consts);
        issuedToken.setOptional(PolicyConstants.isOptional((Element)element));
        issuedToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        String includeAttr = DOMUtils.getAttribute((Element)element, (QName)consts.getIncludeToken());
        if (includeAttr != null) {
            issuedToken.setInclusion(consts.getInclusionFromAttributeValue(includeAttr));
        }
        Element child = DOMUtils.getFirstElement((Node)element);
        while (child != null) {
            String ln = child.getLocalName();
            if ("Issuer".equals(ln)) {
                try {
                    EndpointReferenceType epr = VersionTransformer.parseEndpointReference((Element)child);
                    issuedToken.setIssuerEpr(epr);
                }
                catch (JAXBException e) {
                    throw new IllegalArgumentException(e);
                }
            } else if ("RequestSecurityTokenTemplate".equals(ln)) {
                issuedToken.setRstTemplate(child);
            } else if ("Policy".equals(ln)) {
                Policy policy = this.builder.getPolicy((Object)child);
                Iterator iterator = (policy = policy.normalize(this.builder.getPolicyRegistry(), false)).getAlternatives();
                if (iterator.hasNext()) {
                    this.processAlternative((List)iterator.next(), issuedToken);
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
        return issuedToken;
    }

    private void processAlternative(List<Assertion> assertions, IssuedToken parent) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if ("RequireDerivedKeys".equals(name.getLocalPart())) {
                parent.setDerivedKeys(true);
                continue;
            }
            if ("RequireExternalReference".equals(name.getLocalPart())) {
                parent.setRequireExternalReference(true);
                continue;
            }
            if (!"RequireInternalReference".equals(name.getLocalPart())) continue;
            parent.setRequireInternalReference(true);
        }
    }
}

