/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.sts.cache.STSTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelCastTokenStore
implements STSTokenStore {
    IMap<Object, Object> cacheMap;
    boolean autoRemove = true;

    public HazelCastTokenStore(String mapName) {
        this.cacheMap = Hazelcast.getDefaultInstance().getMap(mapName);
    }

    public void add(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cacheMap.put((Object)token.getId(), (Object)token);
        }
    }

    public void update(SecurityToken token) {
        if (this.autoRemove && (token.getState() == SecurityToken.State.EXPIRED || token.getState() == SecurityToken.State.CANCELLED)) {
            this.remove(token);
        } else {
            this.add(token);
        }
    }

    public void remove(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cacheMap.remove((Object)token.getId());
        }
    }

    public Collection<String> getTokenIdentifiers() {
        return CastUtils.cast((Collection)this.cacheMap.keySet());
    }

    public Collection<SecurityToken> getExpiredTokens() {
        return null;
    }

    public Collection<SecurityToken> getValidTokens() {
        return CastUtils.cast((Collection)this.cacheMap.keySet());
    }

    public Collection<SecurityToken> getRenewedTokens() {
        return null;
    }

    public Collection<SecurityToken> getCancelledTokens() {
        return null;
    }

    public SecurityToken getToken(String id) {
        return (SecurityToken)this.cacheMap.get((Object)id);
    }

    public SecurityToken getTokenByAssociatedHash(int hashCode) {
        Iterator ids = this.cacheMap.keySet().iterator();
        while (ids.hasNext()) {
            SecurityToken securityToken = this.getToken((String)ids.next());
            if (hashCode != securityToken.getAssociatedHash()) continue;
            return securityToken;
        }
        return null;
    }

    public void removeExpiredTokens() {
    }

    public void removeCancelledTokens() {
    }

    public void setAutoRemoveTokens(boolean auto) {
        this.autoRemove = auto;
    }

    @Override
    public void add(SecurityToken token, Integer timeToLiveSeconds) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cacheMap.put((Object)token.getId(), (Object)token, (long)timeToLiveSeconds.intValue(), TimeUnit.SECONDS);
        }
    }
}

