/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.request.Entropy;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.util.WSSecurityUtil;

public class SymmetricKeyHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(SymmetricKeyHandler.class);
    private int keySize = 256;
    private Entropy clientEntropy;
    private byte[] entropyBytes;
    private byte[] secret;
    private boolean computedKey;

    public SymmetricKeyHandler(TokenProviderParameters tokenParameters) {
        KeyRequirements keyRequirements = tokenParameters.getKeyRequirements();
        this.keySize = Long.valueOf(keyRequirements.getKeySize()).intValue();
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        SignatureProperties signatureProperties = stsProperties.getSignatureProperties();
        if ((long)this.keySize < signatureProperties.getMinimumKeySize() || (long)this.keySize > signatureProperties.getMaximumKeySize()) {
            this.keySize = Long.valueOf(signatureProperties.getKeySize()).intValue();
            LOG.log(Level.WARNING, "Received KeySize of " + keyRequirements.getKeySize() + " not accepted so defaulting to " + signatureProperties.getKeySize());
        }
        this.clientEntropy = keyRequirements.getEntropy();
        if (this.clientEntropy == null) {
            LOG.log(Level.WARNING, "A SymmetricKey KeyType is requested, but no client entropy is provided");
        } else {
            String computedKeyAlgorithm;
            String binarySecurityType = this.clientEntropy.getBinarySecretType();
            byte[] nonce = this.clientEntropy.getBinarySecretValue();
            if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512/Nonce".equals(binarySecurityType)) {
                LOG.log(Level.WARNING, "The type " + binarySecurityType + " is not supported");
                throw new STSException("No user supplied entropy for SymmetricKey case", STSException.INVALID_REQUEST);
            }
            if (nonce == null || nonce.length < this.keySize / 8) {
                LOG.log(Level.WARNING, "User Entropy rejected");
                this.clientEntropy = null;
            }
            if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512/CK/PSHA1".equals(computedKeyAlgorithm = keyRequirements.getComputedKeyAlgorithm())) {
                LOG.log(Level.WARNING, "The computed key algorithm of " + computedKeyAlgorithm + " is not supported");
                throw new STSException("Computed Key Algorithm not supported", STSException.INVALID_REQUEST);
            }
        }
    }

    public void createSymmetricKey() {
        try {
            this.entropyBytes = WSSecurityUtil.generateNonce((int)(this.keySize / 8));
            this.secret = this.entropyBytes;
            this.computedKey = false;
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "", ex);
            throw new STSException("Error in creating symmetric key", (Throwable)ex, STSException.INVALID_REQUEST);
        }
        if (this.clientEntropy != null) {
            byte[] nonce = this.clientEntropy.getBinarySecretValue();
            try {
                P_SHA1 psha1 = new P_SHA1();
                this.secret = psha1.createKey(nonce, this.entropyBytes, 0, (long)(this.keySize / 8));
                this.computedKey = true;
            }
            catch (ConversationException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in creating symmetric key", STSException.INVALID_REQUEST);
            }
        }
    }

    public long getKeySize() {
        return this.keySize;
    }

    public byte[] getEntropyBytes() {
        return this.entropyBytes;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public boolean isComputedKey() {
        return this.computedKey;
    }
}

