/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.cxf.tools.corba.common.idltypes.IdlField;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;
import org.apache.cxf.tools.corba.common.idltypes.IdlUnion;

public final class IdlUnionBranch
extends IdlField {
    private boolean isDefault;
    private List<Object> cases;

    private IdlUnionBranch(IdlUnion union, String name, IdlType type, boolean hasDefault) {
        super(union, name, type);
        this.isDefault = hasDefault;
        this.cases = new Vector<Object>();
    }

    public static IdlUnionBranch create(IdlUnion union, String name, IdlType type, boolean isDefault) {
        return new IdlUnionBranch(union, name, type, isDefault);
    }

    public void addCase(String label) {
        if (!this.isDefault) {
            this.cases.add(label);
        }
    }

    public void write(PrintWriter pw) {
        if (this.isDefault) {
            pw.println(IdlUnionBranch.indent() + "default:");
        } else {
            Iterator<Object> it = this.cases.iterator();
            while (it.hasNext()) {
                pw.println(IdlUnionBranch.indent() + "case " + it.next() + ":");
            }
        }
        IdlUnionBranch.indentMore();
        super.write(pw);
        IdlUnionBranch.indentLess();
    }
}

