/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.claims.Claim;
import org.apache.cxf.sts.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ClaimsParser;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.ws.security.sts.provider.STSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimsManager {
    private static final Logger LOG = LogUtils.getL7dLogger(ClaimsManager.class);
    private List<ClaimsParser> claimParsers;
    private List<ClaimsHandler> claimHandlers;
    private List<URI> supportedClaimTypes = new ArrayList<URI>();

    public List<URI> getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    public List<ClaimsParser> getClaimParsers() {
        return this.claimParsers;
    }

    public List<ClaimsHandler> getClaimHandlers() {
        return this.claimHandlers;
    }

    public void setClaimParsers(List<ClaimsParser> claimParsers) {
        this.claimParsers = claimParsers;
    }

    public void setClaimHandlers(List<ClaimsHandler> claimHandlers) {
        this.claimHandlers = claimHandlers;
        if (claimHandlers == null) {
            this.supportedClaimTypes.clear();
        } else {
            for (ClaimsHandler handler : claimHandlers) {
                this.supportedClaimTypes.addAll(handler.getSupportedClaimTypes());
            }
        }
    }

    @Deprecated
    public ClaimCollection retrieveClaimValues(Principal principal, RequestClaimCollection claims, WebServiceContext context, String realm) {
        if (this.claimHandlers != null && this.claimHandlers.size() > 0 && claims != null && claims.size() > 0) {
            ClaimCollection returnCollection = new ClaimCollection();
            for (ClaimsHandler handler : this.claimHandlers) {
                ClaimCollection claimCollection = handler.retrieveClaimValues(principal, claims, context, realm);
                if (claimCollection == null || claimCollection.size() == 0) continue;
                returnCollection.addAll(claimCollection);
            }
            this.validateClaimValues(claims, returnCollection);
            return returnCollection;
        }
        return null;
    }

    public ClaimCollection retrieveClaimValues(RequestClaimCollection claims, ClaimsParameters parameters) {
        if (this.claimHandlers != null && this.claimHandlers.size() > 0 && claims != null && claims.size() > 0) {
            ClaimCollection returnCollection = new ClaimCollection();
            for (ClaimsHandler handler : this.claimHandlers) {
                ClaimCollection claimCollection = handler.retrieveClaimValues(claims, parameters);
                if (claimCollection == null || claimCollection.size() == 0) continue;
                returnCollection.addAll(claimCollection);
            }
            this.validateClaimValues(claims, returnCollection);
            return returnCollection;
        }
        return null;
    }

    private boolean validateClaimValues(RequestClaimCollection requestedClaims, ClaimCollection claims) {
        for (RequestClaim claim : requestedClaims) {
            URI claimType = claim.getClaimType();
            boolean found = false;
            if (claim.isOptional()) continue;
            for (Claim c : claims) {
                if (!c.getClaimType().equals(claimType)) continue;
                found = true;
                break;
            }
            if (found) continue;
            LOG.warning("Mandatory claim not found: " + claim.getClaimType());
            throw new STSException("Mandatory claim '" + claim.getClaimType() + "' not found");
        }
        return true;
    }
}

