/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.services;

import java.lang.management.ManagementFactory;
import javax.jms.ConnectionFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.cxf.wsn.AbstractCreatePullPoint;
import org.apache.cxf.wsn.AbstractNotificationBroker;
import org.apache.cxf.wsn.services.JaxwsCreatePullPoint;
import org.apache.cxf.wsn.services.JaxwsNotificationBroker;

public class Service {
    String rootURL = "http://0.0.0.0:9000/wsn";
    String activeMqUrl = "vm:(broker:(tcp://localhost:6000)?persistent=false)";
    boolean jmxEnable = true;
    AbstractCreatePullPoint createPullPointServer;
    AbstractNotificationBroker notificationBrokerServer;

    public Service(String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if ("-brokerUrl".equals(args[x])) {
                this.activeMqUrl = args[++x];
                continue;
            }
            if ("-rootUrl".equals(args[x])) {
                this.rootURL = args[++x];
                continue;
            }
            if (!"-jmxEnable".equals(args[x])) continue;
            this.jmxEnable = Boolean.valueOf(args[++x]);
        }
    }

    public static void main(String[] args) throws Exception {
        new Service(args).start();
    }

    public void start() throws Exception {
        ActiveMQConnectionFactory activemq = new ActiveMQConnectionFactory(this.activeMqUrl);
        this.notificationBrokerServer = new JaxwsNotificationBroker("WSNotificationBroker", (ConnectionFactory)activemq);
        this.notificationBrokerServer.setAddress(this.rootURL + "/NotificationBroker");
        this.notificationBrokerServer.init();
        this.createPullPointServer = new JaxwsCreatePullPoint("CreatePullPoint", (ConnectionFactory)activemq);
        this.createPullPointServer.setAddress(this.rootURL + "/CreatePullPoint");
        this.createPullPointServer.init();
        if (this.jmxEnable) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nbServerName = new ObjectName("org.apache.cxf.service.mbeans:type=WSNotificationBroker");
            ObjectName cpServerName = new ObjectName("org.apache.cxf.service.mbeans:type=CreatePullPoint");
            mbs.registerMBean(this.notificationBrokerServer, nbServerName);
            mbs.registerMBean(this.createPullPointServer, cpServerName);
        }
    }
}

