/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlBase64InHandler;

public class SamlFormInHandler
extends AbstractSamlBase64InHandler {
    private static final String SAML_ELEMENT = "SAMLToken";
    private static final String SAML_RELAY_STATE = "RelayState";
    private FormEncodingProvider provider = new FormEncodingProvider();

    public SamlFormInHandler() {
        this.provider.setExpectedEncoded(true);
    }

    public Response handleRequest(Message message, ClassResourceInfo resourceClass) {
        UriInfoImpl ui;
        Form form = this.readFormData(message);
        String assertion = (String)form.getData().getFirst((Object)SAML_ELEMENT);
        this.handleToken(message, assertion);
        String samlRequestURI = (String)form.getData().getFirst((Object)SAML_RELAY_STATE);
        if (samlRequestURI != null && !samlRequestURI.startsWith((ui = new UriInfoImpl(message)).getBaseUri().toString())) {
            return Response.status((int)302).location(URI.create(samlRequestURI)).build();
        }
        CachedOutputStream os = new CachedOutputStream();
        form.getData().remove((Object)SAML_ELEMENT);
        form.getData().remove((Object)SAML_RELAY_STATE);
        try {
            this.provider.writeTo((Object)form, Form.class, Form.class, new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MultivaluedMap)new MetadataMap(), (OutputStream)os);
            message.setContent(InputStream.class, (Object)os.getInputStream());
        }
        catch (Exception ex) {
            this.throwFault(ex.getMessage(), ex);
        }
        return null;
    }

    private Form readFormData(Message message) {
        try {
            return (Form)this.provider.readFrom(Form.class, Form.class, new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MultivaluedMap)new MetadataMap(), (InputStream)message.getContent(InputStream.class));
        }
        catch (Exception ex) {
            this.throwFault("Error reading the form", ex);
            return null;
        }
    }
}

