/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.RequestParser;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderResponse;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.StatusType;
import org.apache.cxf.ws.security.sts.provider.operation.ValidateOperation;
import org.apache.ws.security.WSSecurityException;

public class TokenValidateOperation
extends AbstractOperation
implements ValidateOperation {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenValidateOperation.class);

    public RequestSecurityTokenResponseType validate(RequestSecurityTokenType request, WebServiceContext context) {
        TokenValidatorResponse tokenResponse;
        RequestParser requestParser = this.parseRequest(request, context);
        TokenRequirements tokenRequirements = requestParser.getTokenRequirements();
        ReceivedToken validateTarget = tokenRequirements.getValidateTarget();
        if (validateTarget == null || validateTarget.getToken() == null) {
            throw new STSException("No element presented for validation", STSException.INVALID_REQUEST);
        }
        if (tokenRequirements.getTokenType() == null) {
            tokenRequirements.setTokenType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status");
            LOG.fine("Received TokenType is null, falling back to default token type: http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status");
        }
        String realm = null;
        if (this.stsProperties.getRealmParser() != null) {
            RealmParser realmParser = this.stsProperties.getRealmParser();
            realm = realmParser.parseRealm(context);
        }
        if ((tokenResponse = this.validateReceivedToken(context, realm, tokenRequirements, validateTarget)) == null) {
            LOG.fine("No Token Validator has been found that can handle this token");
            tokenResponse = new TokenValidatorResponse();
            tokenResponse.setValid(false);
        }
        TokenProviderResponse tokenProviderResponse = null;
        String tokenType = tokenRequirements.getTokenType();
        if (tokenResponse.isValid() && !"http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status".equals(tokenType)) {
            TokenProviderParameters providerParameters = this.createTokenProviderParameters(requestParser, context);
            Principal responsePrincipal = tokenResponse.getPrincipal();
            if (responsePrincipal != null) {
                String targetRealm = providerParameters.getRealm();
                String sourceRealm = tokenResponse.getTokenRealm();
                IdentityMapper identityMapper = this.stsProperties.getIdentityMapper();
                if (sourceRealm != null && !sourceRealm.equals(targetRealm) && identityMapper != null) {
                    Principal targetPrincipal = identityMapper.mapPrincipal(sourceRealm, responsePrincipal, targetRealm);
                    providerParameters.setPrincipal(targetPrincipal);
                } else {
                    providerParameters.setPrincipal(responsePrincipal);
                }
            }
            RequestClaimCollection requestedClaims = providerParameters.getRequestedClaims();
            this.checkClaimsSupport(requestedClaims);
            providerParameters.setClaimsManager(this.claimsManager);
            Map<String, Object> additionalProperties = tokenResponse.getAdditionalProperties();
            if (additionalProperties != null) {
                providerParameters.setAdditionalProperties(additionalProperties);
            }
            realm = providerParameters.getRealm();
            for (TokenProvider tokenProvider : this.tokenProviders) {
                boolean canHandle = false;
                canHandle = realm == null ? tokenProvider.canHandleToken(tokenType) : tokenProvider.canHandleToken(tokenType, realm);
                if (!canHandle) continue;
                try {
                    tokenProviderResponse = tokenProvider.createToken(providerParameters);
                    break;
                }
                catch (STSException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw new STSException("Error in providing a token", (Throwable)ex, STSException.REQUEST_FAILED);
                }
            }
            if (tokenProviderResponse == null || tokenProviderResponse.getToken() == null) {
                LOG.fine("No Token Provider has been found that can handle this token");
                throw new STSException("No token provider found for requested token type: " + tokenType, STSException.REQUEST_FAILED);
            }
        }
        try {
            return this.createResponse(tokenResponse, tokenProviderResponse, tokenRequirements);
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "", ex);
            throw new STSException("Error in creating the response", ex, STSException.REQUEST_FAILED);
        }
    }

    private RequestSecurityTokenResponseType createResponse(TokenValidatorResponse tokenResponse, TokenProviderResponse tokenProviderResponse, TokenRequirements tokenRequirements) throws WSSecurityException {
        RequestSecurityTokenResponseType response = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseType();
        String context = tokenRequirements.getContext();
        if (context != null) {
            response.setContext(context);
        }
        boolean valid = tokenResponse.isValid();
        String tokenType = tokenRequirements.getTokenType();
        if (valid || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status".equals(tokenType)) {
            JAXBElement jaxbTokenType = QNameConstants.WS_TRUST_FACTORY.createTokenType(tokenType);
            response.getAny().add(jaxbTokenType);
        }
        StatusType statusType = QNameConstants.WS_TRUST_FACTORY.createStatusType();
        if (valid) {
            statusType.setCode("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid");
            statusType.setReason("The Trust service successfully validated the input");
        } else {
            statusType.setCode("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/invalid");
            statusType.setReason("The Trust service did not successfully validate the input");
        }
        JAXBElement status = QNameConstants.WS_TRUST_FACTORY.createStatus(statusType);
        response.getAny().add(status);
        if (valid && !"http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status".equals(tokenType) && tokenProviderResponse != null && tokenProviderResponse.getToken() != null) {
            RequestedSecurityTokenType requestedTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityTokenType();
            JAXBElement requestedToken = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityToken(requestedTokenType);
            requestedTokenType.setAny((Object)tokenProviderResponse.getToken());
            response.getAny().add(requestedToken);
            LifetimeType lifetime = TokenValidateOperation.createLifetime(tokenProviderResponse.getLifetime());
            JAXBElement lifetimeType = QNameConstants.WS_TRUST_FACTORY.createLifetime(lifetime);
            response.getAny().add(lifetimeType);
            if (this.returnReferences) {
                TokenReference attachedReference = tokenProviderResponse.getAttachedReference();
                RequestedReferenceType requestedAttachedReferenceType = null;
                requestedAttachedReferenceType = attachedReference != null ? TokenValidateOperation.createRequestedReference(attachedReference, true) : TokenValidateOperation.createRequestedReference(tokenProviderResponse.getTokenId(), tokenRequirements.getTokenType(), true);
                JAXBElement requestedAttachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedAttachedReference(requestedAttachedReferenceType);
                response.getAny().add(requestedAttachedReference);
                TokenReference unAttachedReference = tokenProviderResponse.getUnAttachedReference();
                RequestedReferenceType requestedUnattachedReferenceType = null;
                requestedUnattachedReferenceType = unAttachedReference != null ? TokenValidateOperation.createRequestedReference(unAttachedReference, false) : TokenValidateOperation.createRequestedReference(tokenProviderResponse.getTokenId(), tokenRequirements.getTokenType(), false);
                JAXBElement requestedUnattachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedUnattachedReference(requestedUnattachedReferenceType);
                response.getAny().add(requestedUnattachedReference);
            }
        }
        return response;
    }
}

