/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.request;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.claims.ClaimsParser;
import org.apache.cxf.sts.claims.IdentityClaimsParser;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.sts.request.Entropy;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.Lifetime;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.BinarySecretType;
import org.apache.cxf.ws.security.sts.provider.model.CancelTargetType;
import org.apache.cxf.ws.security.sts.provider.model.ClaimsType;
import org.apache.cxf.ws.security.sts.provider.model.EntropyType;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.OnBehalfOfType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.UseKeyType;
import org.apache.cxf.ws.security.sts.provider.model.ValidateTargetType;
import org.apache.cxf.ws.security.sts.provider.model.secext.ReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.secext.SecurityTokenReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.wstrust14.ActAsType;
import org.apache.cxf.ws.security.sts.provider.model.xmldsig.KeyInfoType;
import org.apache.cxf.ws.security.sts.provider.model.xmldsig.X509DataType;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParser {
    private static final Logger LOG = LogUtils.getL7dLogger(RequestParser.class);
    private KeyRequirements keyRequirements = new KeyRequirements();
    private TokenRequirements tokenRequirements = new TokenRequirements();

    @Deprecated
    public void parseRequest(RequestSecurityTokenType request, WebServiceContext wsContext) throws STSException {
        this.parseRequest(request, wsContext, null, null);
    }

    public void parseRequest(RequestSecurityTokenType request, WebServiceContext wsContext, STSPropertiesMBean stsProperties, List<ClaimsParser> claimsParsers) throws STSException {
        LOG.fine("Parsing RequestSecurityToken");
        this.keyRequirements = new KeyRequirements();
        this.tokenRequirements = new TokenRequirements();
        for (Object requestObject : request.getAny()) {
            if (requestObject instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)requestObject;
                boolean found = RequestParser.parseTokenRequirements(jaxbElement, this.tokenRequirements, wsContext, claimsParsers);
                if (!found) {
                    found = RequestParser.parseKeyRequirements(jaxbElement, this.keyRequirements);
                }
                if (found) continue;
                LOG.log(Level.WARNING, "Found a JAXB object of unknown type: " + jaxbElement.getName());
                throw new STSException("An unknown element was received", STSException.BAD_REQUEST);
            }
            if (requestObject instanceof Element) {
                Element element = (Element)requestObject;
                if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(element.getNamespaceURI()) && "SecondaryParameters".equals(element.getLocalName())) {
                    this.parseSecondaryParameters(element, claimsParsers);
                    continue;
                }
                if ("AppliesTo".equals(element.getLocalName()) && ("http://www.w3.org/ns/ws-policy".equals(element.getNamespaceURI()) || "http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getNamespaceURI()))) {
                    this.tokenRequirements.setAppliesTo(element);
                    LOG.fine("Found AppliesTo element");
                    continue;
                }
                LOG.log(Level.WARNING, "An unknown (DOM) element was received: " + element.getLocalName());
                throw new STSException("An unknown element was received", STSException.BAD_REQUEST);
            }
            LOG.log(Level.WARNING, "An unknown element was received");
            throw new STSException("An unknown element was received", STSException.BAD_REQUEST);
        }
        String context = request.getContext();
        this.tokenRequirements.setContext(context);
        LOG.fine("Received Context attribute: " + context);
    }

    public KeyRequirements getKeyRequirements() {
        return this.keyRequirements;
    }

    public TokenRequirements getTokenRequirements() {
        return this.tokenRequirements;
    }

    private static boolean parseKeyRequirements(JAXBElement<?> jaxbElement, KeyRequirements keyRequirements) {
        if (QNameConstants.AUTHENTICATION_TYPE.equals(jaxbElement.getName())) {
            String authenticationType = (String)jaxbElement.getValue();
            keyRequirements.setAuthenticationType(authenticationType);
            LOG.fine("Found AuthenticationType: " + authenticationType);
        } else if (QNameConstants.KEY_TYPE.equals(jaxbElement.getName())) {
            String keyType = (String)jaxbElement.getValue();
            keyRequirements.setKeyType(keyType);
            LOG.fine("Found KeyType: " + keyType);
        } else if (QNameConstants.KEY_SIZE.equals(jaxbElement.getName())) {
            long keySize = (Long)jaxbElement.getValue();
            keyRequirements.setKeySize(keySize);
            LOG.fine("Found KeySize: " + keySize);
        } else if (QNameConstants.SIGNATURE_ALGORITHM.equals(jaxbElement.getName())) {
            String signatureAlgorithm = (String)jaxbElement.getValue();
            keyRequirements.setSignatureAlgorithm(signatureAlgorithm);
            LOG.fine("Found Signature Algorithm: " + signatureAlgorithm);
        } else if (QNameConstants.ENCRYPTION_ALGORITHM.equals(jaxbElement.getName())) {
            String encryptionAlgorithm = (String)jaxbElement.getValue();
            keyRequirements.setEncryptionAlgorithm(encryptionAlgorithm);
            LOG.fine("Found Encryption Algorithm: " + encryptionAlgorithm);
        } else if (QNameConstants.C14N_ALGORITHM.equals(jaxbElement.getName())) {
            String c14nAlgorithm = (String)jaxbElement.getValue();
            keyRequirements.setC14nAlgorithm(c14nAlgorithm);
            LOG.fine("Found C14n Algorithm: " + c14nAlgorithm);
        } else if (QNameConstants.COMPUTED_KEY_ALGORITHM.equals(jaxbElement.getName())) {
            String computedKeyAlgorithm = (String)jaxbElement.getValue();
            keyRequirements.setComputedKeyAlgorithm(computedKeyAlgorithm);
            LOG.fine("Found ComputedKeyAlgorithm: " + computedKeyAlgorithm);
        } else if (QNameConstants.KEYWRAP_ALGORITHM.equals(jaxbElement.getName())) {
            String keywrapAlgorithm = (String)jaxbElement.getValue();
            keyRequirements.setKeywrapAlgorithm(keywrapAlgorithm);
            LOG.fine("Found KeyWrapAlgorithm: " + keywrapAlgorithm);
        } else if (QNameConstants.USE_KEY.equals(jaxbElement.getName())) {
            UseKeyType useKey = (UseKeyType)jaxbElement.getValue();
            X509Certificate cert = RequestParser.parseUseKey(useKey);
            keyRequirements.setCertificate(cert);
        } else if (QNameConstants.ENTROPY.equals(jaxbElement.getName())) {
            EntropyType entropyType = (EntropyType)jaxbElement.getValue();
            Entropy entropy = RequestParser.parseEntropy(entropyType);
            keyRequirements.setEntropy(entropy);
        } else if (!QNameConstants.REQUEST_TYPE.equals(jaxbElement.getName())) {
            return false;
        }
        return true;
    }

    private static boolean parseTokenRequirements(JAXBElement<?> jaxbElement, TokenRequirements tokenRequirements, WebServiceContext wsContext, List<ClaimsParser> claimsParsers) {
        if (QNameConstants.TOKEN_TYPE.equals(jaxbElement.getName())) {
            String tokenType = (String)jaxbElement.getValue();
            tokenRequirements.setTokenType(tokenType);
            LOG.fine("Found TokenType: " + tokenType);
        } else if (QNameConstants.ON_BEHALF_OF.equals(jaxbElement.getName())) {
            OnBehalfOfType onBehalfOfType = (OnBehalfOfType)jaxbElement.getValue();
            ReceivedToken onBehalfOf = new ReceivedToken(onBehalfOfType.getAny());
            tokenRequirements.setOnBehalfOf(onBehalfOf);
            LOG.fine("Found OnBehalfOf token");
        } else if (QNameConstants.ACT_AS.equals(jaxbElement.getName())) {
            ActAsType actAsType = (ActAsType)jaxbElement.getValue();
            ReceivedToken actAs = new ReceivedToken(actAsType.getAny());
            tokenRequirements.setActAs(actAs);
            LOG.fine("Found ActAs token");
        } else if (QNameConstants.LIFETIME.equals(jaxbElement.getName())) {
            LifetimeType lifetimeType = (LifetimeType)jaxbElement.getValue();
            Lifetime lifetime = new Lifetime();
            if (lifetimeType.getCreated() != null) {
                lifetime.setCreated(lifetimeType.getCreated().getValue());
            }
            if (lifetimeType.getExpires() != null) {
                lifetime.setExpires(lifetimeType.getExpires().getValue());
            }
            tokenRequirements.setLifetime(lifetime);
            LOG.fine("Found Lifetime element");
        } else if (QNameConstants.VALIDATE_TARGET.equals(jaxbElement.getName())) {
            ValidateTargetType validateTargetType = (ValidateTargetType)jaxbElement.getValue();
            ReceivedToken validateTarget = new ReceivedToken(validateTargetType.getAny());
            if (RequestParser.isTokenReferenced(validateTarget)) {
                validateTarget = RequestParser.fetchTokenFromReference(validateTarget, wsContext);
            }
            tokenRequirements.setValidateTarget(validateTarget);
            LOG.fine("Found ValidateTarget token");
        } else if (QNameConstants.CANCEL_TARGET.equals(jaxbElement.getName())) {
            CancelTargetType cancelTargetType = (CancelTargetType)jaxbElement.getValue();
            ReceivedToken cancelTarget = new ReceivedToken(cancelTargetType.getAny());
            if (RequestParser.isTokenReferenced(cancelTarget)) {
                cancelTarget = RequestParser.fetchTokenFromReference(cancelTarget, wsContext);
            }
            tokenRequirements.setCancelTarget(cancelTarget);
            LOG.fine("Found CancelTarget token");
        } else if (QNameConstants.CLAIMS.equals(jaxbElement.getName())) {
            ClaimsType claimsType = (ClaimsType)jaxbElement.getValue();
            RequestClaimCollection requestedClaims = RequestParser.parseClaims(claimsType, claimsParsers);
            tokenRequirements.setClaims(requestedClaims);
            LOG.fine("Found Claims token");
        } else {
            return false;
        }
        return true;
    }

    private static X509Certificate parseUseKey(UseKeyType useKey) throws STSException {
        Element elementNSImpl;
        NodeList x509CertData;
        byte[] x509 = null;
        KeyInfoType keyInfoType = RequestParser.extractType(useKey.getAny(), KeyInfoType.class);
        if (null != keyInfoType) {
            LOG.fine("Found KeyInfo UseKey type");
            block4: for (Object keyInfoContent : keyInfoType.getContent()) {
                X509DataType x509DataType = RequestParser.extractType(keyInfoContent, X509DataType.class);
                if (null == x509DataType) continue;
                LOG.fine("Found X509Data KeyInfo type");
                for (Object x509Object : x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                    x509 = RequestParser.extractType(x509Object, byte[].class);
                    if (null == x509) continue;
                    LOG.fine("Found X509Certificate UseKey type");
                    continue block4;
                }
            }
        } else if (useKey.getAny() instanceof Element && (x509CertData = (elementNSImpl = (Element)useKey.getAny()).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate")) != null && x509CertData.getLength() > 0) {
            try {
                x509 = Base64Utility.decode((String)x509CertData.item(0).getTextContent().trim());
                LOG.fine("Found X509Certificate UseKey type");
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "", e);
                throw new STSException(e.getMessage(), (Throwable)e, STSException.INVALID_REQUEST);
            }
        }
        if (x509 != null) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(x509));
                LOG.fine("Successfully parsed X509 Certificate from UseKey");
                return cert;
            }
            catch (CertificateException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in parsing certificate: ", (Throwable)ex, STSException.INVALID_REQUEST);
            }
        }
        return null;
    }

    private static <T> T extractType(Object param, Class<T> clazz) {
        JAXBElement jaxbElement;
        if (param instanceof JAXBElement && clazz == (jaxbElement = (JAXBElement)param).getDeclaredType()) {
            return clazz.cast(jaxbElement.getValue());
        }
        return null;
    }

    private static Entropy parseEntropy(EntropyType entropyType) {
        for (Object entropyObject : entropyType.getAny()) {
            JAXBElement entropyObjectJaxb = (JAXBElement)entropyObject;
            if (QNameConstants.BINARY_SECRET.equals(entropyObjectJaxb.getName())) {
                BinarySecretType binarySecret = (BinarySecretType)entropyObjectJaxb.getValue();
                LOG.fine("Found BinarySecret Entropy type");
                Entropy entropy = new Entropy();
                entropy.setBinarySecretType(binarySecret.getType());
                entropy.setBinarySecretValue(binarySecret.getValue());
                return entropy;
            }
            LOG.fine("Unsupported Entropy type: " + entropyObjectJaxb.getName());
        }
        return null;
    }

    private void parseSecondaryParameters(Element secondaryParameters, List<ClaimsParser> claimsParsers) {
        LOG.fine("Found SecondaryParameters element");
        Element child = DOMUtils.getFirstElement((Node)secondaryParameters);
        while (child != null) {
            String localName = child.getLocalName();
            String namespace = child.getNamespaceURI();
            if (this.keyRequirements.getKeySize() == 0L && "KeySize".equals(localName) && "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                long keySize = Integer.parseInt(child.getTextContent().trim());
                this.keyRequirements.setKeySize(keySize);
                LOG.fine("Found KeySize: " + keySize);
            } else if (this.tokenRequirements.getTokenType() == null && "TokenType".equals(localName) && "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                String tokenType = child.getTextContent().trim();
                this.tokenRequirements.setTokenType(tokenType);
                LOG.fine("Found TokenType: " + tokenType);
            } else if (this.keyRequirements.getKeyType() == null && "KeyType".equals(localName) && "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                String keyType = child.getTextContent().trim();
                LOG.fine("Found KeyType: " + keyType);
                this.keyRequirements.setKeyType(keyType);
            } else if (this.tokenRequirements.getClaims() == null && "Claims".equals(localName) && "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(namespace)) {
                LOG.fine("Found Claims element");
                RequestClaimCollection requestedClaims = this.parseClaims(child, claimsParsers);
                this.tokenRequirements.setClaims(requestedClaims);
            } else {
                LOG.fine("Found unknown element: " + localName + " " + namespace);
            }
            child = DOMUtils.getNextElement((Element)child);
        }
    }

    private RequestClaimCollection parseClaims(Element claimsElement, List<ClaimsParser> claimsParsers) {
        String dialectAttr = null;
        RequestClaimCollection requestedClaims = new RequestClaimCollection();
        try {
            dialectAttr = claimsElement.getAttribute("Dialect");
            if (dialectAttr != null && !"".equals(dialectAttr)) {
                requestedClaims.setDialect(new URI(dialectAttr));
            }
        }
        catch (URISyntaxException e1) {
            LOG.log(Level.WARNING, "Cannot create URI from the given Dialect attribute value " + dialectAttr, e1);
        }
        Element childClaimType = DOMUtils.getFirstElement((Node)claimsElement);
        while (childClaimType != null) {
            RequestClaim requestClaim = RequestParser.parseChildClaimType(childClaimType, dialectAttr, claimsParsers);
            if (requestClaim != null) {
                requestedClaims.add(requestClaim);
            }
            childClaimType = DOMUtils.getNextElement((Element)childClaimType);
        }
        return requestedClaims;
    }

    private static RequestClaimCollection parseClaims(ClaimsType claimsType, List<ClaimsParser> claimsParsers) {
        String dialectAttr = null;
        RequestClaimCollection requestedClaims = new RequestClaimCollection();
        try {
            dialectAttr = claimsType.getDialect();
            if (dialectAttr != null && !"".equals(dialectAttr)) {
                requestedClaims.setDialect(new URI(dialectAttr));
            }
        }
        catch (URISyntaxException e1) {
            LOG.log(Level.WARNING, "Cannot create URI from the given Dialect attribute value " + dialectAttr, e1);
        }
        for (Object claim : claimsType.getAny()) {
            RequestClaim requestClaim;
            if (!(claim instanceof Element) || (requestClaim = RequestParser.parseChildClaimType((Element)claim, dialectAttr, claimsParsers)) == null) continue;
            requestedClaims.add(requestClaim);
        }
        return requestedClaims;
    }

    private static RequestClaim parseChildClaimType(Element childClaimType, String dialect, List<ClaimsParser> claimsParsers) {
        if (claimsParsers != null) {
            for (ClaimsParser parser : claimsParsers) {
                if (parser == null || !dialect.equals(parser.getSupportedDialect())) continue;
                return parser.parse(childClaimType);
            }
        }
        if ("http://schemas.xmlsoap.org/ws/2005/05/identity".equals(dialect)) {
            return IdentityClaimsParser.parseClaimType(childClaimType);
        }
        LOG.log(Level.WARNING, "No ClaimsParser is registered for dialect " + dialect);
        throw new STSException("No ClaimsParser is registered for dialect " + dialect, STSException.BAD_REQUEST);
    }

    private static boolean isTokenReferenced(ReceivedToken token) {
        Object targetToken = token.getToken();
        if (targetToken instanceof Element) {
            Element tokenElement = (Element)targetToken;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if ("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(namespace) && "SecurityTokenReference".equals(localname)) {
                return true;
            }
        } else if (targetToken instanceof SecurityTokenReferenceType) {
            return true;
        }
        return false;
    }

    private static ReceivedToken fetchTokenFromReference(ReceivedToken tokenReference, WebServiceContext wsContext) {
        MessageContext messageContext;
        List handlerResults;
        String referenceURI = null;
        Object targetToken = tokenReference.getToken();
        if (targetToken instanceof Element) {
            Element tokenElement = (Element)targetToken;
            NodeList refList = tokenElement.getElementsByTagNameNS("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
            if (refList.getLength() == 0) {
                throw new STSException("Cannot find Reference element in the SecurityTokenReference.", STSException.REQUEST_FAILED);
            }
            referenceURI = refList.item(0).getNodeValue();
        } else if (targetToken instanceof SecurityTokenReferenceType) {
            for (JAXBElement jaxbElement : ((SecurityTokenReferenceType)targetToken).getAny()) {
                if (!(jaxbElement.getValue() instanceof ReferenceType)) continue;
                referenceURI = ((ReferenceType)jaxbElement.getValue()).getURI();
            }
        }
        LOG.fine("Reference URI found " + referenceURI);
        if (referenceURI.charAt(0) == '#') {
            referenceURI = referenceURI.substring(1);
        }
        if ((handlerResults = CastUtils.cast((List)((List)(messageContext = wsContext.getMessageContext()).get((Object)"RECV_RESULTS")))) != null && handlerResults.size() > 0) {
            WSHandlerResult handlerResult = (WSHandlerResult)handlerResults.get(0);
            List engineResults = handlerResult.getResults();
            for (WSSecurityEngineResult engineResult : engineResults) {
                SecurityContextToken sct;
                Integer actInt = (Integer)engineResult.get((Object)"action");
                String id = (String)engineResult.get((Object)"id");
                if (referenceURI.equals(id)) {
                    Element tokenElement = (Element)engineResult.get((Object)"token-element");
                    if (tokenElement == null) {
                        throw new STSException("Cannot retrieve token from reference", STSException.INVALID_REQUEST);
                    }
                    return new ReceivedToken(tokenElement);
                }
                if (actInt != 1024 || !referenceURI.equals((sct = (SecurityContextToken)engineResult.get((Object)"security-context-token")).getIdentifier())) continue;
                return new ReceivedToken(sct.getElement());
            }
        }
        throw new STSException("Cannot retreive token from reference", STSException.REQUEST_FAILED);
    }
}

