/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.realm;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertConstraintsParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CertConstraintsParser.class);
    private Collection<Pattern> subjectDNPatterns = new ArrayList<Pattern>();

    public void setSubjectConstraints(List<String> constraints) {
        if (constraints != null) {
            this.subjectDNPatterns = new ArrayList<Pattern>();
            for (String constraint : constraints) {
                try {
                    this.subjectDNPatterns.add(Pattern.compile(constraint.trim()));
                }
                catch (PatternSyntaxException ex) {
                    LOG.severe(ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    public boolean matches(X509Certificate cert) {
        if (!this.subjectDNPatterns.isEmpty()) {
            if (cert == null) {
                LOG.fine("The certificate is null so no constraints matching was possible");
                return false;
            }
            String subjectName = cert.getSubjectX500Principal().getName();
            boolean subjectMatch = false;
            for (Pattern subjectDNPattern : this.subjectDNPatterns) {
                Matcher matcher = subjectDNPattern.matcher(subjectName);
                if (!matcher.matches()) continue;
                LOG.fine("Subject DN " + subjectName + " matches with pattern " + subjectDNPattern);
                subjectMatch = true;
                break;
            }
            if (!subjectMatch) {
                return false;
            }
        }
        return true;
    }
}

