/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBUtils {
    private JAXBUtils() {
    }

    public static Object convertWithAdapter(Object obj, Class<?> adapterClass, Annotation[] anns) {
        return JAXBUtils.useAdapter(obj, JAXBUtils.getAdapter(adapterClass, anns), false, obj);
    }

    public static Class<?> getValueTypeFromAdapter(Class<?> expectedBoundType, Class<?> defaultClass, Annotation[] anns) {
        try {
            Class<?> boundType;
            XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(expectedBoundType, anns);
            if (adapter != null && (boundType = JAXBUtils.getTypeFromAdapter(adapter, null, true)) != null && boundType.isAssignableFrom(expectedBoundType)) {
                return JAXBUtils.getTypeFromAdapter(adapter, null, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultClass;
    }

    public static XmlJavaTypeAdapter getAdapter(Class<?> objectClass, Annotation[] anns) {
        XmlJavaTypeAdapter typeAdapter = AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class);
        if (typeAdapter == null && (typeAdapter = objectClass.getAnnotation(XmlJavaTypeAdapter.class)) == null) {
            Class<?>[] interfaces = objectClass.getInterfaces();
            typeAdapter = interfaces.length > 0 ? interfaces[0].getAnnotation(XmlJavaTypeAdapter.class) : null;
        }
        return typeAdapter;
    }

    public static Class<?> getTypeFromAdapter(XmlJavaTypeAdapter adapter, Class<?> theType, boolean boundType) {
        if (adapter != null) {
            if (adapter.type() != XmlJavaTypeAdapter.DEFAULT.class) {
                theType = adapter.type();
            } else {
                Type[] types = InjectionUtils.getActualTypes(adapter.value().getGenericSuperclass());
                if (types != null && types.length == 2) {
                    int index = boundType ? 1 : 0;
                    theType = InjectionUtils.getActualType(types[index]);
                }
            }
        }
        return theType;
    }

    public static Object useAdapter(Object obj, XmlJavaTypeAdapter typeAdapter, boolean marshal) {
        return JAXBUtils.useAdapter(obj, typeAdapter, marshal, obj);
    }

    public static Object useAdapter(Object obj, XmlJavaTypeAdapter typeAdapter, boolean marshal, Object defaultValue) {
        if (typeAdapter != null) {
            if (InjectionUtils.isSupportedCollectionOrArray(typeAdapter.value().getClass())) {
                return obj;
            }
            try {
                XmlAdapter xmlAdapter = (XmlAdapter)typeAdapter.value().newInstance();
                if (marshal) {
                    return xmlAdapter.marshal(obj);
                }
                return xmlAdapter.unmarshal(obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return defaultValue;
    }
}

