/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;
import org.apache.cxf.jca.cxf.ResourceAdapterImpl;

public class AssociatedManagedConnectionFactoryImpl
extends ManagedConnectionFactoryImpl
implements ResourceAdapterAssociation {
    private static final long serialVersionUID = 4305487562182780773L;
    private static final Logger LOG = LogUtils.getL7dLogger(AssociatedManagedConnectionFactoryImpl.class);
    private ResourceAdapter ra;

    public AssociatedManagedConnectionFactoryImpl() {
    }

    public AssociatedManagedConnectionFactoryImpl(Properties props) {
        super(props);
    }

    public Object createConnectionFactory(ConnectionManager connMgr) throws ResourceException {
        Object connFactory = super.createConnectionFactory(connMgr);
        this.registerBus();
        return connFactory;
    }

    public void setResourceAdapter(ResourceAdapter aRA) throws ResourceException {
        LOG.info("Associate Resource Adapter with ManagedConnectionFactory by appserver. ra = " + this.ra);
        if (!(aRA instanceof ResourceAdapterImpl)) {
            throw new ResourceAdapterInternalException("ResourceAdapter is not correct, it should be instance of ResourceAdapterImpl");
        }
        this.ra = aRA;
        this.mergeResourceAdapterProps();
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    protected void mergeResourceAdapterProps() {
        Properties raProps = ((ResourceAdapterImpl)this.ra).getPluginProps();
        Properties props = this.getPluginProps();
        Enumeration<?> raPropsEnum = raProps.propertyNames();
        while (raPropsEnum.hasMoreElements()) {
            String key = (String)raPropsEnum.nextElement();
            if (!props.containsKey(key)) {
                this.setProperty(key, raProps.getProperty(key));
                continue;
            }
            LOG.fine("ManagedConnectionFactory's props already contain [" + key + "]. No need to merge");
        }
    }

    protected void registerBus() throws ResourceException {
        if (this.ra == null) {
            throw new ResourceAdapterInternalException("ResourceAdapter can not be null");
        }
        ((ResourceAdapterImpl)this.ra).registerBus(this.getBus());
    }

    protected Object getBootstrapContext() {
        return ((ResourceAdapterImpl)this.ra).getBootstrapContext();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

