/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.EndpointProperties;
import org.apache.cxf.annotations.EndpointProperty;
import org.apache.cxf.annotations.FactoryType;
import org.apache.cxf.annotations.FastInfoset;
import org.apache.cxf.annotations.GZIP;
import org.apache.cxf.annotations.Logging;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.annotations.WSDLDocumentation;
import org.apache.cxf.annotations.WSDLDocumentationCollection;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.FIStaxInInterceptor;
import org.apache.cxf.interceptor.FIStaxOutInterceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.PerRequestFactory;
import org.apache.cxf.service.invoker.PooledFactory;
import org.apache.cxf.service.invoker.SessionFactory;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.apache.cxf.service.invoker.SpringBeanFactory;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.common.gzip.GZIPFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsFactoryBeanListener
implements FactoryBeanListener {
    private static final String EXTRA_DOCUMENTATION = AnnotationsFactoryBeanListener.class.getName() + ".EXTRA_DOCS";

    @Override
    public void handleEvent(FactoryBeanListener.Event ev, AbstractServiceFactoryBean factory, Object ... args) {
        switch (ev) {
            case INTERFACE_CREATED: {
                WSDLDocumentationCollection col;
                InterfaceInfo ii = (InterfaceInfo)args[0];
                Class cls = (Class)args[1];
                WSDLDocumentation doc = cls.getAnnotation(WSDLDocumentation.class);
                if (doc != null) {
                    this.addDocumentation(ii, WSDLDocumentation.Placement.PORT_TYPE, doc);
                }
                if ((col = cls.getAnnotation(WSDLDocumentationCollection.class)) != null) {
                    this.addDocumentation(ii, WSDLDocumentation.Placement.PORT_TYPE, col.value());
                }
                this.setDataBinding(factory, cls.getAnnotation(org.apache.cxf.annotations.DataBinding.class));
                break;
            }
            case ENDPOINT_SELECTED: {
                InterfaceInfo i;
                List docs;
                WSDLDocumentationCollection col;
                Class implCls = args.length > 3 ? (Class)args[3] : null;
                Class cls = (Class)args[2];
                Endpoint ep = (Endpoint)args[1];
                Bus bus = factory.getBus();
                if (cls == null) {
                    return;
                }
                this.addSchemaValidationSupport(ep, cls.getAnnotation(SchemaValidation.class));
                this.addFastInfosetSupport((InterceptorProvider)ep, cls.getAnnotation(FastInfoset.class));
                this.addGZipSupport(ep, bus, cls.getAnnotation(GZIP.class));
                this.addLoggingSupport(ep, bus, cls.getAnnotation(Logging.class));
                this.addEndpointProperties(ep, bus, cls.getAnnotation(EndpointProperty.class));
                EndpointProperties props = cls.getAnnotation(EndpointProperties.class);
                if (props != null) {
                    this.addEndpointProperties(ep, bus, props.value());
                }
                if (implCls == null || implCls == cls) {
                    return;
                }
                WSDLDocumentation doc = implCls.getAnnotation(WSDLDocumentation.class);
                if (doc != null) {
                    this.addDocumentation(ep, WSDLDocumentation.Placement.SERVICE, doc);
                }
                if ((col = implCls.getAnnotation(WSDLDocumentationCollection.class)) != null) {
                    this.addDocumentation(ep, WSDLDocumentation.Placement.SERVICE, col.value());
                }
                if ((docs = CastUtils.cast((List)((List)(i = ep.getEndpointInfo().getInterface()).removeProperty(EXTRA_DOCUMENTATION)))) != null) {
                    this.addDocumentation(ep, WSDLDocumentation.Placement.SERVICE, docs.toArray(new WSDLDocumentation[docs.size()]));
                }
                this.addBindingOperationDocs(ep);
                break;
            }
            case SERVER_CREATED: {
                Class cls = (Class)args[2];
                if (cls == null) {
                    return;
                }
                Server server = (Server)args[0];
                Bus bus = factory.getBus();
                this.addGZipSupport(server.getEndpoint(), bus, cls.getAnnotation(GZIP.class));
                this.addSchemaValidationSupport(server.getEndpoint(), cls.getAnnotation(SchemaValidation.class));
                this.addFastInfosetSupport((InterceptorProvider)server.getEndpoint(), cls.getAnnotation(FastInfoset.class));
                this.addLoggingSupport(server.getEndpoint(), bus, cls.getAnnotation(Logging.class));
                this.addEndpointProperties(server.getEndpoint(), bus, cls.getAnnotation(EndpointProperty.class));
                EndpointProperties props = cls.getAnnotation(EndpointProperties.class);
                if (props != null) {
                    this.addEndpointProperties(server.getEndpoint(), bus, props.value());
                }
                this.setScope(factory, server, cls);
                break;
            }
            case INTERFACE_OPERATION_BOUND: {
                WSDLDocumentationCollection col;
                OperationInfo inf = (OperationInfo)args[0];
                Method m = (Method)args[1];
                WSDLDocumentation doc = m.getAnnotation(WSDLDocumentation.class);
                if (doc != null) {
                    this.addDocumentation(inf, WSDLDocumentation.Placement.PORT_TYPE_OPERATION, doc);
                }
                if ((col = m.getAnnotation(WSDLDocumentationCollection.class)) == null) break;
                this.addDocumentation(inf, WSDLDocumentation.Placement.PORT_TYPE_OPERATION, col.value());
                break;
            }
        }
    }

    private void setScope(AbstractServiceFactoryBean factory, Server server, Class<?> cls) {
        Invoker i;
        FactoryType scope = cls.getAnnotation(FactoryType.class);
        if (scope != null && (i = server.getEndpoint().getService().getInvoker()) instanceof FactoryInvoker) {
            PerRequestFactory f;
            if (scope.factoryClass() == FactoryType.DEFAULT.class) {
                switch (scope.value()) {
                    case Session: {
                        if (scope.args().length > 0) {
                            f = new SessionFactory(cls, Boolean.parseBoolean(scope.args()[0]));
                            break;
                        }
                        f = new SessionFactory(cls);
                        break;
                    }
                    case PerRequest: {
                        f = new PerRequestFactory(cls);
                        break;
                    }
                    case Pooled: {
                        f = new PooledFactory(cls, Integer.parseInt(scope.args()[0]));
                        break;
                    }
                    case Spring: {
                        f = new SpringBeanFactory(scope.args()[0]);
                        break;
                    }
                    default: {
                        f = new SingletonFactory(cls);
                        break;
                    }
                }
            } else {
                try {
                    f = (Factory)scope.factoryClass().getConstructor(Class.class, String[].class).newInstance(cls, scope.args());
                }
                catch (Throwable t) {
                    throw new ServiceConstructionException(t);
                }
            }
            ((FactoryInvoker)i).setFactory((Factory)f);
        }
    }

    private void addEndpointProperties(Endpoint ep, Bus bus, EndpointProperty ... annotations) {
        for (EndpointProperty prop : annotations) {
            if (prop == null) continue;
            String[] s = prop.value();
            if (s.length == 1) {
                ep.getEndpointInfo().setProperty(prop.key(), (Object)s[0]);
                continue;
            }
            ep.getEndpointInfo().setProperty(prop.key(), (Object)s[1]);
        }
    }

    private void setDataBinding(AbstractServiceFactoryBean factory, org.apache.cxf.annotations.DataBinding annotation) {
        if (annotation != null && factory.getDataBinding(false) == null) {
            try {
                if (!StringUtils.isEmpty((String)annotation.ref())) {
                    factory.setDataBinding((DataBinding)((ResourceManager)factory.getBus().getExtension(ResourceManager.class)).resolveResource(annotation.ref(), annotation.value()));
                }
                factory.setDataBinding((DataBinding)annotation.value().newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addLoggingSupport(Endpoint endpoint, Bus bus, Logging annotation) {
        if (annotation != null) {
            LoggingFeature lf = new LoggingFeature(annotation);
            lf.initialize((InterceptorProvider)endpoint, bus);
        }
    }

    private void addGZipSupport(Endpoint ep, Bus bus, GZIP annotation) {
        if (annotation != null) {
            try {
                GZIPFeature feature = new GZIPFeature();
                feature.setThreshold(annotation.threshold());
                feature.initialize((InterceptorProvider)ep, bus);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addSchemaValidationSupport(Endpoint endpoint, SchemaValidation annotation) {
        if (annotation != null) {
            if (!annotation.enabled()) {
                endpoint.put((Object)"schema-validation-enabled", (Object)SchemaValidation.SchemaValidationType.NONE);
            } else {
                endpoint.put((Object)"schema-validation-enabled", (Object)annotation.type());
            }
        }
    }

    private void addFastInfosetSupport(InterceptorProvider provider, FastInfoset annotation) {
        if (annotation != null) {
            FIStaxInInterceptor in = new FIStaxInInterceptor();
            FIStaxOutInterceptor out = new FIStaxOutInterceptor(annotation.force());
            provider.getInInterceptors().add(in);
            provider.getInFaultInterceptors().add(in);
            provider.getOutInterceptors().add(out);
            provider.getOutFaultInterceptors().add(out);
        }
    }

    private void addBindingOperationDocs(Endpoint ep) {
        for (BindingOperationInfo binfo : ep.getBinding().getBindingInfo().getOperations()) {
            List later = CastUtils.cast((List)((List)binfo.getOperationInfo().getProperty(EXTRA_DOCUMENTATION)));
            if (later == null) continue;
            block7: for (WSDLDocumentation doc : later) {
                switch (doc.placement()) {
                    case BINDING_OPERATION: {
                        binfo.setDocumentation(doc.value());
                        break;
                    }
                    case BINDING_OPERATION_INPUT: {
                        binfo.getInput().setDocumentation(doc.value());
                        break;
                    }
                    case BINDING_OPERATION_OUTPUT: {
                        binfo.getOutput().setDocumentation(doc.value());
                        break;
                    }
                    case BINDING_OPERATION_FAULT: {
                        for (BindingFaultInfo f : binfo.getFaults()) {
                            if (!doc.faultClass().equals(f.getFaultInfo().getProperty(Class.class.getName()))) continue;
                            f.setDocumentation(doc.value());
                        }
                        continue block7;
                    }
                }
            }
        }
    }

    private void addDocumentation(OperationInfo inf, WSDLDocumentation.Placement defPlace, WSDLDocumentation ... values) {
        ArrayList<WSDLDocumentation> later = new ArrayList<WSDLDocumentation>();
        block8: for (WSDLDocumentation doc : values) {
            WSDLDocumentation.Placement p = doc.placement();
            if (p == WSDLDocumentation.Placement.DEFAULT) {
                p = defPlace;
            }
            switch (p) {
                case PORT_TYPE_OPERATION: {
                    inf.setDocumentation(doc.value());
                    continue block8;
                }
                case PORT_TYPE_OPERATION_INPUT: {
                    inf.getInput().setDocumentation(doc.value());
                    continue block8;
                }
                case PORT_TYPE_OPERATION_OUTPUT: {
                    inf.getOutput().setDocumentation(doc.value());
                    continue block8;
                }
                case FAULT_MESSAGE: 
                case PORT_TYPE_OPERATION_FAULT: {
                    for (FaultInfo f : inf.getFaults()) {
                        if (!doc.faultClass().equals(f.getProperty(Class.class.getName()))) continue;
                        if (p == WSDLDocumentation.Placement.FAULT_MESSAGE) {
                            f.setMessageDocumentation(doc.value());
                            continue;
                        }
                        f.setDocumentation(doc.value());
                    }
                    continue block8;
                }
                case INPUT_MESSAGE: {
                    inf.getInput().setMessageDocumentation(doc.value());
                    continue block8;
                }
                case OUTPUT_MESSAGE: {
                    inf.getOutput().setMessageDocumentation(doc.value());
                    continue block8;
                }
                default: {
                    later.add(doc);
                }
            }
        }
        if (!later.isEmpty()) {
            List stuff = CastUtils.cast((List)((List)inf.getProperty(EXTRA_DOCUMENTATION)));
            if (stuff != null) {
                stuff.addAll(later);
            } else {
                inf.setProperty(EXTRA_DOCUMENTATION, later);
            }
        }
    }

    private void addDocumentation(InterfaceInfo interfaceInfo, WSDLDocumentation.Placement defPlace, WSDLDocumentation ... values) {
        ArrayList<WSDLDocumentation> later = new ArrayList<WSDLDocumentation>();
        block5: for (WSDLDocumentation doc : values) {
            WSDLDocumentation.Placement p = doc.placement();
            if (p == WSDLDocumentation.Placement.DEFAULT) {
                p = defPlace;
            }
            switch (p) {
                case PORT_TYPE: {
                    interfaceInfo.setDocumentation(doc.value());
                    continue block5;
                }
                case SERVICE: {
                    interfaceInfo.getService().setDocumentation(doc.value());
                    continue block5;
                }
                case TOP: {
                    interfaceInfo.getService().setTopLevelDoc(doc.value());
                    continue block5;
                }
                default: {
                    later.add(doc);
                }
            }
        }
        if (!later.isEmpty()) {
            List stuff = CastUtils.cast((List)((List)interfaceInfo.getProperty(EXTRA_DOCUMENTATION)));
            if (stuff != null) {
                stuff.addAll(later);
            } else {
                interfaceInfo.setProperty(EXTRA_DOCUMENTATION, later);
            }
        }
    }

    private void addDocumentation(Endpoint ep, WSDLDocumentation.Placement defPlace, WSDLDocumentation ... values) {
        block7: for (WSDLDocumentation doc : values) {
            WSDLDocumentation.Placement p = doc.placement();
            if (p == WSDLDocumentation.Placement.DEFAULT) {
                p = defPlace;
            }
            switch (p) {
                case PORT_TYPE: {
                    ep.getEndpointInfo().getService().getInterface().setDocumentation(doc.value());
                    continue block7;
                }
                case TOP: {
                    ep.getEndpointInfo().getService().setTopLevelDoc(doc.value());
                    continue block7;
                }
                case SERVICE: {
                    ep.getEndpointInfo().getService().setDocumentation(doc.value());
                    continue block7;
                }
                case SERVICE_PORT: {
                    ep.getEndpointInfo().setDocumentation(doc.value());
                    continue block7;
                }
                case BINDING: {
                    ep.getEndpointInfo().getBinding().setDocumentation(doc.value());
                    continue block7;
                }
            }
        }
    }
}

