/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMInInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMInInterceptor.class);

    public RMInInterceptor() {
        this.addBefore(MAPAggregator.class.getName());
    }

    public void handleFault(Message message) {
        message.put((Object)MAPAggregator.class.getName(), (Object)true);
        if (MessageUtils.isTrue((Object)message.get((Object)"org.apache.cxf.oneway.robust.delivering"))) {
            try {
                Destination destination = this.getManager().getDestination(message);
                destination.releaseDeliveringStatus(message);
            }
            catch (RMException e) {
                LOG.log(Level.WARNING, "Failed to revert the delivering status");
            }
        }
    }

    @Override
    protected void handle(Message message) throws SequenceFault, RMException {
        String addrUri;
        String rmUri;
        ProtocolVariation protocol;
        Object originalRequestor;
        LOG.entering(((Object)((Object)this)).getClass().getName(), "handleMessage");
        boolean isServer = RMContextUtils.isServerSide(message);
        LOG.fine("isServerSide: " + isServer);
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        AddressingProperties maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)false, (boolean)false);
        if (null == maps) {
            if (isServer) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("WSA_REQUIRED_EXC", LOG, new Object[0]);
                LOG.log(Level.INFO, msg.toString());
                throw new RMException(msg);
            }
            return;
        }
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        if (null != (originalRequestor = message.get((Object)"org.apache.cxf.client.original"))) {
            LOG.fine("Restoring original requestor role to: " + originalRequestor);
            message.put((Object)"org.apache.cxf.client", originalRequestor);
        }
        if (null == (protocol = ProtocolVariation.findVariant(rmUri = rmps.getNamespaceURI(), addrUri = maps.getNamespaceURI()))) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("WSRM_REQUIRED_EXC", LOG, new Object[]{rmUri, addrUri});
            LOG.log(Level.INFO, msg.toString());
            throw new RMException(msg);
        }
        RMContextUtils.setProtocolVariation(message, protocol);
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        LOG.fine("isApplicationMessage: " + isApplicationMessage);
        RMEndpoint rme = this.getManager().getReliableEndpoint(message);
        Destination destination = this.getManager().getDestination(message);
        if (isApplicationMessage) {
            if (null != rmps) {
                this.processAcknowledgments(rme, rmps, protocol);
                this.processAcknowledgmentRequests(destination, message);
                this.processSequence(destination, message);
                this.processDeliveryAssurance(rmps);
            }
            if (ContextUtils.retrieveDeferredUncorrelatedMessageAbort((Message)message)) {
                LOG.info("deferred uncorrelated message abort");
                message.getInterceptorChain().abort();
            } else {
                rme.receivedApplicationMessage();
            }
        } else {
            rme.receivedControlMessage();
            if ("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement".equals(action) || "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement".equals(action)) {
                this.processAcknowledgments(rme, rmps, protocol);
            } else if ("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(action) || "http://docs.oasis-open.org/ws-rx/wsrm/200702/SequenceAcknowledgement".equals(action)) {
                this.processSequence(destination, message);
            } else if (("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence".equals(action) || "http://docs.oasis-open.org/ws-rx/wsrm/200702/CreateSequence".equals(action)) && !isServer) {
                LOG.fine("Processing inbound CreateSequence on client side.");
                Servant servant = rme.getServant();
                Object csr = servant.createSequence(message);
                Proxy proxy = rme.getProxy();
                proxy.createSequenceResponse(csr, protocol);
                return;
            }
        }
        this.assertReliability(message);
    }

    void processAcknowledgments(RMEndpoint rme, RMProperties rmps, ProtocolVariation protocol) throws SequenceFault, RMException {
        Collection<SequenceAcknowledgement> acks = rmps.getAcks();
        Source source = rme.getSource();
        if (null != acks) {
            for (SequenceAcknowledgement ack : acks) {
                Identifier id = ack.getIdentifier();
                SourceSequence ss = source.getSequence(id);
                if (null != ss) {
                    ss.setAcknowledged(ack);
                    continue;
                }
                RMConstants consts = protocol.getConstants();
                SequenceFaultFactory sff = new SequenceFaultFactory(consts);
                throw sff.createUnknownSequenceFault(id);
            }
        }
    }

    void processAcknowledgmentRequests(Destination destination, Message message) throws SequenceFault, RMException {
        destination.ackRequested(message);
    }

    void processSequence(Destination destination, Message message) throws SequenceFault, RMException {
        boolean robust = MessageUtils.isTrue((Object)message.getContextualProperty("org.apache.cxf.oneway.robust"));
        if (robust) {
            message.put((Object)"org.apache.cxf.oneway.robust.delivering", (Object)Boolean.TRUE);
        }
        destination.acknowledge(message);
    }

    void processDeliveryAssurance(RMProperties rmps) {
    }
}

