/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.corba.common.ProcessorEnvironment;
import org.apache.cxf.tools.corba.processors.idl.IDLToWSDLProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLToWSDL
extends AbstractCXFToolContainer {
    static final String TOOL_NAME = "idl2wsdl";
    private static String[] args;

    public IDLToWSDL(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    private Set<String> getArrayKeys() {
        HashSet<String> arrayKeys = new HashSet<String>();
        arrayKeys.add("includedir");
        return arrayKeys;
    }

    public void execute(boolean exitOnFinish) {
        IDLToWSDLProcessor idlProcessor = new IDLToWSDLProcessor();
        ProcessorEnvironment env = null;
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                env = new ProcessorEnvironment();
                env.setParameters(this.getParametersMap(this.getArrayKeys()));
                if (this.isVerboseOn()) {
                    env.put("verbose", Boolean.TRUE);
                }
                env.put("args", args);
                this.initialise(env);
                this.validate(env);
                idlProcessor.setEnvironment(env);
                idlProcessor.process();
            }
        }
        catch (ToolException ex) {
            this.err.println("Error : " + ex.getMessage());
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            this.err.println();
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
            throw ex;
        }
        catch (Exception ex) {
            this.err.println("Error : " + ex.getMessage());
            this.err.println();
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
            throw new ToolException(ex.getMessage(), ex.getCause());
        }
    }

    private void initialise(ProcessorEnvironment env) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (env.optionSet("idl")) {
            String idl = doc.getParameter("idl");
            env.put("idl", idl);
        }
        if (env.optionSet("tns")) {
            env.put("tns", doc.getParameter("tns"));
        }
        if (env.optionSet("outputdir")) {
            env.put("outputdir", doc.getParameter("outputdir"));
        }
        if (env.optionSet("address")) {
            env.put("address", doc.getParameter("address"));
        }
        if (env.optionSet("sequencetype")) {
            env.put("sequencetype", doc.getParameter("sequencetype"));
        }
        if (env.optionSet("schemans")) {
            env.put("schemans", doc.getParameter("schemans"));
        }
        if (env.optionSet("logical")) {
            env.put("logical", doc.getParameter("logical"));
        }
        if (env.optionSet("physical")) {
            env.put("physical", doc.getParameter("physical"));
        }
        if (env.optionSet("schema")) {
            env.put("schema", doc.getParameter("schema"));
        }
        if (env.optionSet("encoding")) {
            env.put("encoding", doc.getParameter("encoding"));
        }
        if (env.optionSet("importschema")) {
            env.put("importschema", doc.getParameter("importschema"));
        }
        if (env.optionSet("moduletonamespace")) {
            env.put("moduletonamespace", doc.getParameter("moduletonamespace"));
        }
        if (env.optionSet("includedir")) {
            env.put("includedir", doc.getParameters("includedir"));
        }
        if (env.optionSet("wsdloutputfile")) {
            env.put("wsdloutputfile", doc.getParameter("wsdloutputfile"));
        }
        if (env.optionSet("excludemodules")) {
            env.put("excludemodules", doc.getParameter("excludemodules"));
        }
    }

    public static void run(String[] arguments) throws Exception {
        ToolRunner.runTool(IDLToWSDL.class, (InputStream)IDLToWSDL.class.getResourceAsStream("/org/apache/cxf/tools/corba/common/toolspec/toolspecs/idl2wsdl.xml"), (boolean)false, (String[])arguments);
    }

    public static void main(String[] arguments) {
        try {
            IDLToWSDL.run(arguments);
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            System.exit(1);
        }
    }

    private void validate(ProcessorEnvironment env) throws ToolException {
        File dir;
        String outdir = (String)env.get("outputdir");
        if (outdir != null && !(dir = new File(outdir)).exists()) {
            dir.mkdir();
        }
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        String addressFileName;
        File addressFile;
        String sequenceOctetType;
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("idl")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("IDL file has to be specified"));
        }
        if (doc.hasParameter("schema") && doc.hasParameter("importschema")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("Options -n & -T cannot be used together"));
        }
        if (doc.hasParameter("moduletonamespace") && (doc.hasParameter("logical") || doc.hasParameter("physical") || doc.hasParameter("schema") || doc.hasParameter("importschema"))) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("Options -mns and -L|-P|-T|-n cannot be use together"));
        }
        if (doc.hasParameter("sequencetype") && (sequenceOctetType = doc.getParameter("sequencetype")) != null && !sequenceOctetType.equals("base64Binary") && !sequenceOctetType.equals("hexBinary")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("Invalid value specified for -s option"));
        }
        if (!(!doc.hasParameter("addressfile") || (addressFile = new File(addressFileName = doc.getParameter("addressfile"))).canRead() && addressFile.isFile())) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("Invalid value specified for -f option\n\"" + addressFileName + "\" cannot be read"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

