/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ReadHeadersInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(ReadHeadersInterceptor.class);
    private Bus bus;
    private SoapVersion version;

    public ReadHeadersInterceptor(Bus b) {
        super("read");
        this.bus = b;
    }

    public ReadHeadersInterceptor(Bus b, SoapVersion v) {
        super("read");
        this.version = v;
        this.bus = b;
    }

    public ReadHeadersInterceptor(Bus b, String phase) {
        super(phase);
        this.bus = b;
    }

    public static SoapVersion readVersion(XMLStreamReader xmlReader, SoapMessage message) {
        String ns = xmlReader.getNamespaceURI();
        if (ns == null || "".equals(ns)) {
            throw new SoapFault(new Message("NO_NAMESPACE", LOG, xmlReader.getLocalName()), Soap11.getInstance().getVersionMismatch());
        }
        SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
        if (soapVersion == null) {
            throw new SoapFault(new Message("INVALID_VERSION", LOG, ns, xmlReader.getLocalName()), Soap11.getInstance().getVersionMismatch());
        }
        message.setVersion(soapVersion);
        return soapVersion;
    }

    public void handleMessage(SoapMessage message) {
        if (this.isGET(message)) {
            LOG.fine("ReadHeadersInterceptor skipped in HTTP GET method");
            return;
        }
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        if (xmlReader == null) {
            InputStream in = message.getContent(InputStream.class);
            if (in == null) {
                throw new RuntimeException("Can't find input stream in message");
            }
            xmlReader = StaxUtils.createXMLStreamReader(in);
        }
        try {
            if (xmlReader.getEventType() == 1 || xmlReader.nextTag() == 1) {
                SoapVersion soapVersion = ReadHeadersInterceptor.readVersion(xmlReader, message);
                if (soapVersion == Soap12.getInstance() && this.version == Soap11.getInstance()) {
                    throw new SoapFault(new Message("INVALID_11_VERSION", LOG, Soap12.getInstance().getNamespace(), xmlReader.getLocalName()), Soap11.getInstance().getVersionMismatch());
                }
                PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
                Node nd = message.getContent(Node.class);
                W3CDOMStreamWriter writer = message.get(W3CDOMStreamWriter.class);
                Document doc = null;
                if (writer != null) {
                    StaxUtils.copy((XMLStreamReader)filteredReader, (XMLStreamWriter)writer);
                    doc = writer.getDocument();
                } else if (nd instanceof Document) {
                    doc = (Document)nd;
                    StaxUtils.readDocElements(doc, doc, filteredReader, false, false);
                } else {
                    doc = StaxUtils.read(filteredReader);
                    message.setContent(Node.class, doc);
                }
                Element element = doc.getDocumentElement();
                QName header = soapVersion.getHeader();
                List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(element, header.getNamespaceURI(), header.getLocalPart());
                for (Element elem : elemList) {
                    Element hel = DOMUtils.getFirstElement(elem);
                    while (hel != null) {
                        Object obj;
                        if (elem.hasAttributes()) {
                            NamedNodeMap nnp = elem.getAttributes();
                            for (int ct = 0; ct < nnp.getLength(); ++ct) {
                                Node headerAttrNode;
                                Node attr = nnp.item(ct);
                                Node node = headerAttrNode = hel.hasAttributes() ? hel.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : null;
                                if (headerAttrNode != null) continue;
                                Attr attribute = hel.getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                                attribute.setNodeValue(attr.getNodeValue());
                                hel.setAttributeNodeNS(attribute);
                            }
                        }
                        HeaderProcessor p = this.bus == null ? null : this.bus.getExtension(HeaderManager.class).getHeaderProcessor(hel.getNamespaceURI());
                        DataBinding dataBinding = null;
                        if (p == null || p.getDataBinding() == null) {
                            obj = hel;
                        } else {
                            dataBinding = p.getDataBinding();
                            obj = dataBinding.createReader(Node.class).read(hel);
                        }
                        SoapHeader shead = new SoapHeader(new QName(hel.getNamespaceURI(), hel.getLocalName()), obj, dataBinding);
                        String mu = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand());
                        String act = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                        if (!StringUtils.isEmpty(act)) {
                            shead.setActor(act);
                        }
                        shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
                        shead.setDirection(Header.Direction.DIRECTION_IN);
                        message.getHeaders().add(shead);
                        hel = DOMUtils.getNextElement(hel);
                    }
                }
                if (MessageUtils.getContextualBoolean(message, "schema-validation-enabled", false)) {
                    message.getInterceptorChain().add(new CheckClosingTagsInterceptor());
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("XML_STREAM_EXC", LOG, new Object[0]), (Throwable)e, message.getVersion().getSender());
        }
    }

    public static class CheckClosingTagsInterceptor
    extends AbstractSoapInterceptor {
        public CheckClosingTagsInterceptor() {
            super("post-logical");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
            if (xmlReader != null) {
                try {
                    while (xmlReader.hasNext()) {
                        if (xmlReader.next() != 8) continue;
                        return;
                    }
                }
                catch (XMLStreamException e) {
                    throw new SoapFault(e.getMessage(), (Throwable)e, message.getVersion().getSender());
                }
            }
        }
    }
}

