/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.Provider;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.SingletonFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSMethodInvoker
extends AbstractJAXWSMethodInvoker {
    public JAXWSMethodInvoker(Object bean) {
        super(new SingletonFactory(bean));
    }

    public JAXWSMethodInvoker(Factory factory) {
        super(factory);
    }

    @Override
    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        WrappedMessageContext ctx = new WrappedMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        Map<String, Object> handlerScopedStuff = this.removeHandlerProperties(ctx);
        WebServiceContextImpl.setMessageContext(ctx);
        List res = null;
        try {
            if ((params == null || params.isEmpty()) && m.getDeclaringClass().equals(Provider.class)) {
                params = Collections.singletonList(null);
            }
            res = CastUtils.cast((List)super.invoke(exchange, serviceObject, m, params));
            if (serviceObject instanceof Provider && MessageUtils.isTrue(exchange.getInMessage().getContextualProperty("jaxws.provider.interpretNullAsOneway")) && res != null && !res.isEmpty() && res.get(0) == null) {
                res = null;
                this.changeToOneway(exchange);
            }
            this.updateWebServiceContext(exchange, ctx);
        }
        catch (Fault f) {
            this.updateHeader(exchange, ctx);
            throw f;
        }
        finally {
            WebServiceContextImpl.clear();
            this.addHandlerProperties(ctx, handlerScopedStuff);
        }
        return res;
    }

    private void changeToOneway(Exchange exchange) {
        exchange.setOneWay(true);
        exchange.setOutMessage(null);
        HttpServletResponse httpresp = (HttpServletResponse)exchange.getInMessage().get("HTTP.RESPONSE");
        if (httpresp != null) {
            httpresp.setStatus(202);
        }
    }
}

