/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.io.IOException;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.bean.AttributeStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthDecisionStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthenticationStatementBean;
import org.apache.ws.security.saml.ext.bean.ConditionsBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.opensaml.common.SAMLVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlCallbackHandler
implements CallbackHandler {
    private TokenProviderParameters tokenParameters;
    private List<AttributeStatementBean> attributeBeans;
    private List<AuthenticationStatementBean> authBeans;
    private List<AuthDecisionStatementBean> authDecisionBeans;
    private ConditionsBean conditionsBean;
    private SubjectBean subjectBean;
    private String issuer;

    public void setAttributeBeans(List<AttributeStatementBean> attributeBeanList) {
        this.attributeBeans = attributeBeanList;
    }

    public void setAuthenticationBeans(List<AuthenticationStatementBean> authBeanList) {
        this.authBeans = authBeanList;
    }

    public void setAuthDecisionStatementBeans(List<AuthDecisionStatementBean> authDecisionBeanList) {
        this.authDecisionBeans = authDecisionBeanList;
    }

    public void setSubjectBean(SubjectBean subjectBean) {
        this.subjectBean = subjectBean;
    }

    public void setConditionsBean(ConditionsBean conditionsBean) {
        this.conditionsBean = conditionsBean;
    }

    public void setTokenProviderParameters(TokenProviderParameters tokenProviderParameters) {
        this.tokenParameters = tokenProviderParameters;
    }

    public void setIssuer(String issuerName) {
        this.issuer = issuerName;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            TokenRequirements tokenRequirements;
            String tokenType;
            if (!(callbacks[i] instanceof SAMLCallback)) continue;
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            if (this.subjectBean != null) {
                callback.setSubject(this.subjectBean);
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType = (tokenRequirements = this.tokenParameters.getTokenRequirements()).getTokenType()) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                callback.setSamlVersion(SAMLVersion.VERSION_20);
            } else {
                callback.setSamlVersion(SAMLVersion.VERSION_11);
                this.setSubjectOnBeans();
            }
            if (this.issuer == null) {
                STSPropertiesMBean stsProperties = this.tokenParameters.getStsProperties();
                callback.setIssuer(stsProperties.getIssuer());
            } else {
                callback.setIssuer(this.issuer);
            }
            if (this.attributeBeans != null && !this.attributeBeans.isEmpty()) {
                callback.setAttributeStatementData(this.attributeBeans);
            }
            if (this.authBeans != null && !this.authBeans.isEmpty()) {
                callback.setAuthenticationStatementData(this.authBeans);
            }
            if (this.authDecisionBeans != null && !this.authDecisionBeans.isEmpty()) {
                callback.setAuthDecisionStatementData(this.authDecisionBeans);
            }
            callback.setConditions(this.conditionsBean);
        }
    }

    private void setSubjectOnBeans() {
        if (this.attributeBeans != null) {
            for (AttributeStatementBean attributeBean : this.attributeBeans) {
                if (attributeBean.getSubject() != null) continue;
                attributeBean.setSubject(this.subjectBean);
            }
        }
        if (this.authBeans != null) {
            for (AuthenticationStatementBean authBean : this.authBeans) {
                if (authBean.getSubject() != null) continue;
                authBean.setSubject(this.subjectBean);
            }
        }
        if (this.authDecisionBeans != null) {
            for (AuthDecisionStatementBean authDecisionBean : this.authDecisionBeans) {
                if (authDecisionBean.getSubject() != null) continue;
                authDecisionBean.setSubject(this.subjectBean);
            }
        }
    }
}

