/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.services;

import javax.management.MBeanServer;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.blueprint.BlueprintBus;
import org.apache.cxf.wsn.EndpointRegistrationException;
import org.apache.cxf.wsn.services.JaxwsEndpointManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;

public class OSGiJaxwsEndpointManager
extends JaxwsEndpointManager {
    private BundleContext bundleContext;
    private BlueprintContainer container;
    private Object cxfBus;
    private boolean hasCXF = true;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.mbeanServer = (MBeanServer)bundleContext.getService(bundleContext.getServiceReference(MBeanServer.class.getName()));
    }

    public void setBlueprintContainer(BlueprintContainer c) {
        this.container = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint register(String address, Object service) throws EndpointRegistrationException {
        Object o = this.setCXFBus();
        try {
            Endpoint endpoint = super.register(address, service);
            return endpoint;
        }
        finally {
            this.restoreCXFBus(o);
        }
    }

    private void restoreCXFBus(Object o) {
        if (this.hasCXF) {
            this.restoreCXFBusInternal(o);
        }
    }

    private Object setCXFBus() {
        if (this.cxfBus == null && this.hasCXF) {
            try {
                this.createCXFBus();
            }
            catch (Throwable t) {
                this.hasCXF = false;
            }
        }
        if (this.hasCXF) {
            return this.setCXFBusInternal();
        }
        return null;
    }

    public void destroy() {
        if (this.cxfBus != null) {
            this.destroyBus();
        }
    }

    private void destroyBus() {
        ((Bus)this.cxfBus).shutdown(true);
        this.cxfBus = null;
    }

    private void restoreCXFBusInternal(Object o) {
        BusFactory.setThreadDefaultBus((Bus)((Bus)o));
    }

    private Object setCXFBusInternal() {
        return BusFactory.getAndSetThreadDefaultBus((Bus)((Bus)this.cxfBus));
    }

    private void createCXFBus() {
        BlueprintBus bp = new BlueprintBus();
        bp.setBundleContext(this.bundleContext);
        bp.setBlueprintContainer(this.container);
        bp.setId("WS-Notification");
        bp.initialize();
        this.cxfBus = bp;
    }
}

