/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.fiql;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.cxf.jaxrs.ext.search.AndSearchCondition;
import org.apache.cxf.jaxrs.ext.search.Beanspector;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionParser;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.SimpleSearchCondition;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiqlParser<T>
implements SearchConditionParser<T> {
    public static final String OR = ",";
    public static final String AND = ";";
    public static final String GT = "=gt=";
    public static final String GE = "=ge=";
    public static final String LT = "=lt=";
    public static final String LE = "=le=";
    public static final String EQ = "==";
    public static final String NEQ = "!=";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final Pattern COMPARATORS_PATTERN;
    private static final Map<String, ConditionType> OPERATORS_MAP;
    private Beanspector<T> beanspector;
    private Class<T> conditionClass;
    private Map<String, String> properties;

    public FiqlParser(Class<T> tclass) {
        this(tclass, Collections.emptyMap());
    }

    public FiqlParser(Class<T> tclass, Map<String, String> contextProperties) {
        this.beanspector = SearchBean.class.isAssignableFrom(tclass) ? null : new Beanspector<Class<Class<Class<Class<T>>>>>(tclass);
        this.conditionClass = tclass;
        this.properties = contextProperties;
    }

    @Override
    public SearchCondition<T> parse(String fiqlExpression) throws SearchParseException {
        ASTNode<T> ast = this.parseAndsOrsBrackets(fiqlExpression);
        return ast.build();
    }

    private ASTNode<T> parseAndsOrsBrackets(String expr) throws SearchParseException {
        ArrayList<String> subexpressions = new ArrayList<String>();
        ArrayList<String> operators = new ArrayList<String>();
        int level = 0;
        int lastIdx = 0;
        int idx = 0;
        for (idx = 0; idx < expr.length(); ++idx) {
            boolean isEnd;
            boolean isOperator;
            char c = expr.charAt(idx);
            if (c == '(') {
                ++level;
            } else if (c == ')' && --level < 0) {
                throw new SearchParseException(String.format("Unexpected closing bracket at position %d", idx));
            }
            String cs = Character.toString(c);
            boolean bl = isOperator = AND.equals(cs) || OR.equals(cs);
            if (level == 0 && isOperator) {
                String s1 = expr.substring(lastIdx, idx);
                String s2 = expr.substring(idx, idx + 1);
                subexpressions.add(s1);
                operators.add(s2);
                lastIdx = idx + 1;
            }
            boolean bl2 = isEnd = idx == expr.length() - 1;
            if (!isEnd) continue;
            String s1 = expr.substring(lastIdx, idx + 1);
            subexpressions.add(s1);
            operators.add(null);
            lastIdx = idx + 1;
        }
        if (level != 0) {
            throw new SearchParseException(String.format("Unmatched opening and closing brackets in expression: %s", expr));
        }
        if (operators.get(operators.size() - 1) != null) {
            String op = (String)operators.get(operators.size() - 1);
            String ex = (String)subexpressions.get(subexpressions.size() - 1);
            throw new SearchParseException("Dangling operator at the end of expression: ..." + ex + op);
        }
        int from = 0;
        int to = 0;
        SubExpression ors = new SubExpression(OR);
        while (to < operators.size()) {
            while (to < operators.size() && AND.equals(operators.get(to))) {
                ++to;
            }
            SubExpression ands = new SubExpression(AND);
            while (from <= to) {
                String subex = (String)subexpressions.get(from);
                ASTNode node = null;
                node = subex.startsWith("(") ? this.parseAndsOrsBrackets(subex.substring(1, subex.length() - 1)) : this.parseComparison(subex);
                ands.add(node);
                ++from;
            }
            to = from;
            if (ands.getSubnodes().size() == 1) {
                ors.add(ands.getSubnodes().get(0));
                continue;
            }
            ors.add(ands);
        }
        if (ors.getSubnodes().size() == 1) {
            return ors.getSubnodes().get(0);
        }
        return ors;
    }

    private Comparison parseComparison(String expr) throws SearchParseException {
        Matcher m = COMPARATORS_PATTERN.matcher(expr);
        if (m.find()) {
            String name = expr.substring(0, m.start(1));
            String operator = m.group(1);
            String value = expr.substring(m.end(1));
            if ("".equals(value)) {
                throw new SearchParseException("Not a comparison expression: " + expr);
            }
            Object castedValue = this.parseDatatype(name, value);
            return new Comparison(name, operator, castedValue);
        }
        throw new SearchParseException("Not a comparison expression: " + expr);
    }

    private Object parseDatatype(String setter, String value) throws SearchParseException {
        Class<String> valueType;
        Object castedValue = value;
        try {
            valueType = this.beanspector != null ? this.beanspector.getAccessorType(setter) : String.class;
        }
        catch (Exception e) {
            throw new SearchParseException(e);
        }
        if (Date.class.isAssignableFrom(valueType)) {
            try {
                int idx;
                SimpleDateFormat df = SearchUtils.getDateFormat(this.properties, DEFAULT_DATE_FORMAT);
                String dateValue = value;
                if (SearchUtils.isTimeZoneSupported(this.properties, Boolean.TRUE) && (idx = value.lastIndexOf(58)) != -1) {
                    dateValue = value.substring(0, idx) + value.substring(idx + 1);
                }
                castedValue = df.parse(dateValue);
            }
            catch (ParseException e) {
                try {
                    Date now = new Date();
                    DatatypeFactory.newInstance().newDuration(value).addTo(now);
                    castedValue = now;
                }
                catch (DatatypeConfigurationException e1) {
                    throw new SearchParseException(e1);
                }
                catch (IllegalArgumentException e1) {
                    throw new SearchParseException("Can parse " + value + " neither as date nor duration", e);
                }
            }
        } else {
            try {
                castedValue = InjectionUtils.convertStringToPrimitive((String)value, valueType);
            }
            catch (Exception e) {
                throw new SearchParseException("Cannot convert String value \"" + value + "\" to a value of class " + valueType.getName(), e);
            }
        }
        return castedValue;
    }

    static {
        OPERATORS_MAP = new HashMap<String, ConditionType>();
        OPERATORS_MAP.put(GT, ConditionType.GREATER_THAN);
        OPERATORS_MAP.put(GE, ConditionType.GREATER_OR_EQUALS);
        OPERATORS_MAP.put(LT, ConditionType.LESS_THAN);
        OPERATORS_MAP.put(LE, ConditionType.LESS_OR_EQUALS);
        OPERATORS_MAP.put(EQ, ConditionType.EQUALS);
        OPERATORS_MAP.put(NEQ, ConditionType.NOT_EQUALS);
        String comparators = "=gt=|=ge=|=lt=|=le=|==|!=";
        String s1 = "[\\p{ASCII}]+(" + comparators + ")";
        COMPARATORS_PATTERN = Pattern.compile(s1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Comparison
    implements ASTNode<T> {
        private String name;
        private String operator;
        private Object value;

        public Comparison(String name, String operator, Object value) {
            this.name = name;
            this.operator = operator;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getOperator() {
            return this.operator;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + " " + this.operator + " " + this.value + " (" + this.value.getClass().getSimpleName() + ")";
        }

        @Override
        public SearchCondition<T> build() throws SearchParseException {
            Object cond = this.createTemplate(this.name, this.value);
            ConditionType ct = (ConditionType)((Object)OPERATORS_MAP.get(this.operator));
            if (this.isPrimitive(cond)) {
                return new SimpleSearchCondition(ct, cond);
            }
            return new SimpleSearchCondition(Collections.singletonMap(this.name, ct), cond);
        }

        private boolean isPrimitive(T pojo) {
            return pojo.getClass().getName().startsWith("java.lang");
        }

        private T createTemplate(String setter, Object val) throws SearchParseException {
            try {
                if (FiqlParser.this.beanspector != null) {
                    FiqlParser.this.beanspector.instantiate().setValue(setter, val);
                    return FiqlParser.this.beanspector.getBean();
                }
                SearchBean bean = (SearchBean)FiqlParser.this.conditionClass.newInstance();
                bean.set(setter, this.value.toString());
                return bean;
            }
            catch (Throwable e) {
                throw new SearchParseException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubExpression
    implements ASTNode<T> {
        private String operator;
        private List<ASTNode<T>> subnodes = new ArrayList();

        public SubExpression(String operator) {
            this.operator = operator;
        }

        public void add(ASTNode<T> node) {
            this.subnodes.add(node);
        }

        public List<ASTNode<T>> getSubnodes() {
            return Collections.unmodifiableList(this.subnodes);
        }

        public String toString() {
            String s = this.operator.equals(FiqlParser.AND) ? "AND" : "OR";
            s = s + ":[";
            for (int i = 0; i < this.subnodes.size(); ++i) {
                s = s + this.subnodes.get(i);
                if (i >= this.subnodes.size() - 1) continue;
                s = s + ", ";
            }
            s = s + "]";
            return s;
        }

        @Override
        public SearchCondition<T> build() throws SearchParseException {
            boolean hasSubtree = false;
            for (ASTNode node : this.subnodes) {
                if (!(node instanceof SubExpression)) continue;
                hasSubtree = true;
                break;
            }
            if (!hasSubtree && FiqlParser.AND.equals(this.operator) && FiqlParser.this.beanspector != null) {
                try {
                    LinkedHashMap<String, ConditionType> map = new LinkedHashMap<String, ConditionType>();
                    FiqlParser.this.beanspector.instantiate();
                    for (ASTNode node : this.subnodes) {
                        Comparison comp = (Comparison)node;
                        map.put(comp.getName(), (ConditionType)((Object)OPERATORS_MAP.get(comp.getOperator())));
                        FiqlParser.this.beanspector.setValue(comp.getName(), comp.getValue());
                    }
                    return new SimpleSearchCondition(map, FiqlParser.this.beanspector.getBean());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayList scNodes = new ArrayList();
            for (ASTNode node : this.subnodes) {
                scNodes.add(node.build());
            }
            if (FiqlParser.OR.equals(this.operator)) {
                return new OrSearchCondition(scNodes);
            }
            return new AndSearchCondition(scNodes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ASTNode<T> {
        public SearchCondition<T> build() throws SearchParseException;
    }
}

