/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.rs.security.oauth2.client.HttpRequestProperties;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.mac.MacAuthorizationScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthClientUtils {
    private OAuthClientUtils() {
    }

    public static URI getAuthorizationURI(String authorizationServiceURI, String clientId, String redirectUri, String state, String scope) {
        UriBuilder ub = OAuthClientUtils.getAuthorizationURIBuilder(authorizationServiceURI, clientId, scope);
        if (redirectUri != null) {
            ub.queryParam("redirect_uri", new Object[]{redirectUri});
        }
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub.build(new Object[0]);
    }

    public static UriBuilder getAuthorizationURIBuilder(String authorizationServiceURI, String clientId, String scope) {
        UriBuilder ub = UriBuilder.fromUri((String)authorizationServiceURI);
        if (clientId != null) {
            ub.queryParam("client_id", new Object[]{clientId});
        }
        if (scope != null) {
            ub.queryParam("scope", new Object[]{scope});
        }
        ub.queryParam("response_type", new Object[]{"code"});
        return ub;
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant) throws OAuthServiceException {
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, true);
    }

    public static ClientAccessToken getAccessToken(String accessTokenServiceUri, Consumer consumer, AccessTokenGrant grant, boolean setAuthorizationHeader) throws OAuthServiceException {
        OAuthJSONProvider provider = new OAuthJSONProvider();
        WebClient accessTokenService = WebClient.create((String)accessTokenServiceUri, Collections.singletonList(provider));
        accessTokenService.accept(new String[]{"application/json"});
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, grant, true);
    }

    public static ClientAccessToken getAccessToken(WebClient accessTokenService, Consumer consumer, AccessTokenGrant grant, boolean setAuthorizationHeader) throws OAuthServiceException {
        Form form = new Form(grant.toMap());
        if (consumer != null) {
            if (setAuthorizationHeader) {
                StringBuilder sb = new StringBuilder();
                sb.append("Basic ");
                try {
                    String data = consumer.getKey() + ":" + consumer.getSecret();
                    sb.append(Base64Utility.encode((byte[])data.getBytes("UTF-8")));
                }
                catch (Exception ex) {
                    throw new ClientWebApplicationException((Throwable)ex);
                }
                accessTokenService.header("Authorization", new Object[]{sb.toString()});
            } else {
                form.set("client_id", (Object)consumer.getKey());
                form.set("client_secret", (Object)consumer.getSecret());
            }
        }
        Response response = accessTokenService.form(form);
        Map<String, String> map = null;
        try {
            map = new OAuthJSONProvider().readJSONResponse((InputStream)response.getEntity());
        }
        catch (IOException ex) {
            throw new ClientWebApplicationException((Throwable)ex);
        }
        if (200 == response.getStatus()) {
            ClientAccessToken token = OAuthClientUtils.fromMapToClientToken(map);
            if (token == null) {
                throw new OAuthServiceException("server_error");
            }
            return token;
        }
        if (400 == response.getStatus() && map.containsKey("error")) {
            OAuthError error = new OAuthError(map.get("error"), map.get("error_description"));
            error.setErrorUri(map.get("error_uri"));
            throw new OAuthServiceException(error);
        }
        throw new OAuthServiceException("server_error");
    }

    public static ClientAccessToken fromMapToClientToken(Map<String, String> map) {
        if (map.containsKey("access_token") && map.containsKey("token_type")) {
            String issuedAtStr;
            String expiresInStr;
            ClientAccessToken token = new ClientAccessToken(map.remove("token_type"), map.remove("access_token"));
            String refreshToken = map.remove("refresh_token");
            if (refreshToken != null) {
                token.setRefreshToken(refreshToken);
            }
            if ((expiresInStr = map.remove("expires_in")) != null) {
                token.setExpiresIn(Long.valueOf(expiresInStr));
            }
            token.setIssuedAt((issuedAtStr = map.remove("issued_at")) != null ? Long.valueOf(issuedAtStr) : System.currentTimeMillis() / 1000L);
            String scope = map.remove("scope");
            if (scope != null) {
                token.setApprovedScope(scope);
            }
            token.setParameters(map);
            return token;
        }
        return null;
    }

    public static String createAuthorizationHeader(Consumer consumer, ClientAccessToken accessToken) throws OAuthServiceException {
        StringBuilder sb = new StringBuilder();
        OAuthClientUtils.appendTokenData(sb, accessToken, null);
        return sb.toString();
    }

    public static String createAuthorizationHeader(Consumer consumer, ClientAccessToken accessToken, HttpRequestProperties httpProps) throws OAuthServiceException {
        StringBuilder sb = new StringBuilder();
        OAuthClientUtils.appendTokenData(sb, accessToken, httpProps);
        return sb.toString();
    }

    private static void appendTokenData(StringBuilder sb, ClientAccessToken token, HttpRequestProperties httpProps) throws OAuthServiceException {
        if ("bearer".equals(token.getTokenType())) {
            sb.append("Bearer");
            sb.append(" ");
            sb.append(token.getTokenKey());
        } else if ("mac".equals(token.getTokenType())) {
            if (httpProps == null) {
                throw new IllegalArgumentException("MAC scheme requires HTTP Request properties");
            }
            MacAuthorizationScheme macAuthData = new MacAuthorizationScheme(httpProps, token);
            String macAlgo = token.getParameters().get("mac_algorithm");
            String macKey = token.getParameters().get("mac_key");
            sb.append(macAuthData.toAuthorizationHeader(macAlgo, macKey));
        } else {
            throw new ClientWebApplicationException((Throwable)new OAuthServiceException("Unsupported token type"));
        }
    }

    public static class Consumer {
        private String key;
        private String secret;

        public Consumer(String key, String secret) {
            this.key = key;
            this.secret = secret;
        }

        public String getKey() {
            return this.key;
        }

        public String getSecret() {
            return this.secret;
        }
    }
}

