/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientHandler;
import org.apache.cxf.transport.https.SSLUtils;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class NettyHttpClientPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpClientPipelineFactory.class);
    private final TLSClientParameters tlsClientParameters;

    public NettyHttpClientPipelineFactory(TLSClientParameters tlsClientParameters) {
        this.tlsClientParameters = tlsClientParameters;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(0x100000));
        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("client", (ChannelHandler)new NettyHttpClientHandler());
        return pipeline;
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (this.tlsClientParameters != null) {
            SSLEngine sslEngine = SSLUtils.createClientSSLEngine((TLSClientParameters)this.tlsClientParameters);
            return new SslHandler(sslEngine);
        }
        return null;
    }
}

