/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.netty.client.NettyHttpConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@NoJSR250Annotations(unlessNull={"bus"})
public class NettyHttpConduitFactory
implements BusLifeCycleListener,
HTTPConduitFactory {
    boolean isShutdown;
    final ExecutorService bossExecutor = Executors.newCachedThreadPool();
    final ExecutorService workerExecutor = Executors.newCachedThreadPool();

    public NettyHttpConduitFactory() {
    }

    public NettyHttpConduitFactory(Bus b) {
        this();
        this.addListener(b);
    }

    @Resource
    public void setBus(Bus b) {
        this.addListener(b);
    }

    private void addListener(Bus b) {
        ((BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
    }

    public HTTPConduit createConduit(HTTPTransportFactory f, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        return new NettyHttpConduit(f.getBus(), localInfo, target, this);
    }

    public HTTPConduit createConduit(Bus bus, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        return new NettyHttpConduit(bus, localInfo, target, this);
    }

    public void initComplete() {
        this.isShutdown = false;
    }

    public void preShutdown() {
        this.isShutdown = true;
    }

    public void postShutdown() {
        this.bossExecutor.shutdown();
        this.workerExecutor.shutdown();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public Executor getWorkExecutor() {
        return this.workerExecutor;
    }

    public Executor getBossExecutor() {
        return this.bossExecutor;
    }
}

