/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AlgorithmSuite;
import org.apache.ws.security.components.crypto.AlgorithmSuiteValidator;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog(SAMLTokenProcessor.class);
    private XMLSignatureFactory signatureFactory;

    public SAMLTokenProcessor() {
        try {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            this.signatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
    }

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        String id;
        Element foundElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found SAML Assertion element");
        }
        Validator validator = data.getValidator(new QName(elem.getNamespaceURI(), elem.getLocalName()));
        Credential credential = this.handleSAMLToken(elem, data, validator, wsDocInfo);
        AssertionWrapper assertion = credential.getAssertion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SAML Assertion issuer " + assertion.getIssuerString()));
            log.debug((Object)DOM2Writer.nodeToString(elem));
        }
        if (elem.equals(foundElement = wsDocInfo.getTokenElement(id = assertion.getId()))) {
            WSSecurityEngineResult result = wsDocInfo.getResult(id);
            return Collections.singletonList(result);
        }
        if (foundElement != null) {
            throw new WSSecurityException(4, "duplicateError");
        }
        wsDocInfo.addTokenElement(elem);
        WSSecurityEngineResult result = null;
        result = assertion.isSigned() ? new WSSecurityEngineResult(16, assertion) : new WSSecurityEngineResult(8, assertion);
        result.put("id", assertion.getId());
        if (validator != null) {
            result.put("validated-token", Boolean.TRUE);
            if (credential.getTransformedToken() != null) {
                result.put("transformed-token", credential.getTransformedToken());
                SAMLTokenPrincipal samlPrincipal = new SAMLTokenPrincipal(credential.getTransformedToken());
                result.put("principal", samlPrincipal);
            } else if (credential.getPrincipal() != null) {
                result.put("principal", credential.getPrincipal());
            } else {
                result.put("principal", new SAMLTokenPrincipal(assertion));
            }
        }
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }

    public Credential handleSAMLToken(Element token, RequestData data, Validator validator, WSDocInfo docInfo) throws WSSecurityException {
        AssertionWrapper assertion = new AssertionWrapper(token);
        if (assertion.isSigned()) {
            AlgorithmSuite algorithmSuite = data.getSamlAlgorithmSuite();
            Signature sig = assertion.getSignature();
            KeyInfo keyInfo = sig.getKeyInfo();
            if (keyInfo == null) {
                throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
            }
            SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo(keyInfo.getDOM(), data, docInfo, data.getWssConfig().isWsiBSPCompliant());
            if (algorithmSuite != null) {
                XMLSignature xmlSignature;
                AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
                PublicKey key = null;
                if (samlKeyInfo.getCerts() != null && samlKeyInfo.getCerts()[0] != null) {
                    key = samlKeyInfo.getCerts()[0].getPublicKey();
                } else if (samlKeyInfo.getPublicKey() != null) {
                    key = samlKeyInfo.getPublicKey();
                } else {
                    throw new WSSecurityException(0, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"});
                }
                DOMValidateContext context = new DOMValidateContext(key, (Node)sig.getDOM());
                context.setProperty("org.apache.jcp.xml.dsig.secureValidation", Boolean.TRUE);
                context.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
                try {
                    xmlSignature = this.signatureFactory.unmarshalXMLSignature(context);
                }
                catch (MarshalException ex) {
                    throw new WSSecurityException(6, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key"}, ex);
                }
                algorithmSuiteValidator.checkSignatureAlgorithms(xmlSignature);
                algorithmSuiteValidator.checkAsymmetricKeyLength(key);
            }
            assertion.verifySignature(samlKeyInfo);
        }
        assertion.parseHOKSubject(data, docInfo);
        Credential credential = new Credential();
        credential.setAssertion(assertion);
        if (validator != null) {
            return validator.validate(credential, data);
        }
        return credential;
    }
}

