/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http.netty.server.NettyHttpHandler;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletContext;

public class NettyHttpContextHandler {
    private final ServletContext servletContext;
    private List<NettyHttpHandler> nettyHttpHandlerList = new CopyOnWriteArrayList<NettyHttpHandler>();

    public NettyHttpContextHandler(String contextPath) {
        this.servletContext = new NettyServletContext(contextPath);
    }

    public void addNettyHttpHandler(NettyHttpHandler handler) {
        handler.setServletContext(this.servletContext);
        this.nettyHttpHandlerList.add(handler);
    }

    public NettyHttpHandler getNettyHttpHandler(String urlName) {
        for (NettyHttpHandler handler : this.nettyHttpHandlerList) {
            if (!urlName.equals(handler.getName())) continue;
            return handler;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.nettyHttpHandlerList.isEmpty();
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public void removeNettyHttpHandler(String urlName) {
        NettyHttpHandler handler = this.getNettyHttpHandler(urlName);
        if (handler != null) {
            this.nettyHttpHandlerList.remove(handler);
        }
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        for (NettyHttpHandler handler : this.nettyHttpHandlerList) {
            handler.handle(target, request, response);
        }
    }
}

