/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.http.netty.server.NettyHttpContextHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServletPipelineFactory;
import org.apache.cxf.transport.http.netty.server.interceptor.NettyInterceptor;
import org.apache.cxf.transport.http.netty.server.servlet.NettyHttpServletRequest;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletResponse;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.util.CharsetUtil;

public class NettyHttpServletHandler
extends IdleStateAwareChannelHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServletHandler.class);
    private final ChannelGroup allChannels;
    private final NettyHttpServletPipelineFactory pipelineFactory;
    private List<NettyInterceptor> interceptors;

    public NettyHttpServletHandler(NettyHttpServletPipelineFactory pipelineFactory) {
        this.allChannels = pipelineFactory.getAllChannels();
        this.pipelineFactory = pipelineFactory;
    }

    public NettyHttpServletHandler addInterceptor(NettyInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<NettyInterceptor>();
        }
        this.interceptors.add(interceptor);
        return this;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.log(Level.FINE, "Opening new channel: {}", e.getChannel().getId());
        this.allChannels.add((Object)e.getChannel());
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        LOG.log(Level.FINE, "Closing idle channel: {}", e.getChannel().getId());
        e.getChannel().close();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        NettyHttpContextHandler nettyHttpContextHandler;
        HttpRequest request = (HttpRequest)e.getMessage();
        if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
            e.getChannel().write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        if ((nettyHttpContextHandler = this.pipelineFactory.getNettyHttpHandler(request.getUri())) == null) {
            throw new RuntimeException("No handler found for uri: " + request.getUri());
        }
        this.handleHttpServletRequest(ctx, e, nettyHttpContextHandler);
    }

    protected void handleHttpServletRequest(ChannelHandlerContext ctx, MessageEvent e, NettyHttpContextHandler nettyHttpContextHandler) throws Exception {
        this.interceptOnRequestReceived(ctx, e);
        HttpRequest request = (HttpRequest)e.getMessage();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        NettyServletResponse nettyServletResponse = this.buildHttpServletResponse((HttpResponse)response);
        NettyHttpServletRequest nettyServletRequest = this.buildHttpServletRequest(request, nettyHttpContextHandler.getContextPath(), ctx);
        nettyHttpContextHandler.handle(nettyServletRequest.getRequestURI(), nettyServletRequest, nettyServletResponse);
        this.interceptOnRequestSuccessed(ctx, e, (HttpResponse)response);
        nettyServletResponse.getWriter().flush();
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        if (keepAlive) {
            response.setHeader("Content-Length", (Object)response.getContent().readableBytes());
            response.setHeader("Connection", (Object)"keep-alive");
        }
        ChannelFuture future = e.getChannel().write((Object)response);
        if (!keepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Throwable cause = e.getCause();
        LOG.log(Level.SEVERE, "Unexpected exception from downstream.", cause);
        this.interceptOnRequestFailed(ctx, e);
        Channel ch = e.getChannel();
        if (cause instanceof IllegalArgumentException) {
            ch.close();
        } else {
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (ch.isConnected()) {
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private void interceptOnRequestReceived(ChannelHandlerContext ctx, MessageEvent e) {
        if (this.interceptors != null) {
            for (NettyInterceptor interceptor : this.interceptors) {
                interceptor.onRequestReceived(ctx, e);
            }
        }
    }

    private void interceptOnRequestSuccessed(ChannelHandlerContext ctx, MessageEvent e, HttpResponse response) {
        if (this.interceptors != null) {
            for (NettyInterceptor interceptor : this.interceptors) {
                interceptor.onRequestSuccessed(ctx, e, response);
            }
        }
    }

    private void interceptOnRequestFailed(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (this.interceptors != null) {
            for (NettyInterceptor interceptor : this.interceptors) {
                interceptor.onRequestFailed(ctx, e);
            }
        }
    }

    protected NettyServletResponse buildHttpServletResponse(HttpResponse response) {
        return new NettyServletResponse(response);
    }

    protected NettyHttpServletRequest buildHttpServletRequest(HttpRequest request, String contextPath, ChannelHandlerContext ctx) {
        return new NettyHttpServletRequest(request, contextPath, ctx);
    }
}

