/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.http.netty.server.NettyHttpContextHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServletHandler;
import org.apache.cxf.transport.http.netty.server.interceptor.ChannelInterceptor;
import org.apache.cxf.transport.http.netty.server.interceptor.HttpSessionInterceptor;
import org.apache.cxf.transport.http.netty.server.session.DefaultHttpSessionStore;
import org.apache.cxf.transport.http.netty.server.session.HttpSessionStore;
import org.apache.cxf.transport.https.SSLUtils;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;

public class NettyHttpServletPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServletPipelineFactory.class);
    private final ChannelGroup allChannels = new DefaultChannelGroup();
    private final HttpSessionWatchdog watchdog;
    private final ChannelHandler idleStateHandler;
    private final TLSServerParameters tlsServerParameters;
    private final boolean supportSession;
    private final ExecutorService applicationExecutor;
    private final ExecutionHandler executionHandler;
    private final Map<String, NettyHttpContextHandler> handlerMap;
    private final int maxChunkContentSize;

    public NettyHttpServletPipelineFactory(TLSServerParameters tlsServerParameters, boolean supportSession, int threadPoolSize, int maxChunkContentSize, Map<String, NettyHttpContextHandler> handlerMap, IdleStateHandler idleStateHandler) {
        this.supportSession = supportSession;
        this.idleStateHandler = idleStateHandler;
        this.watchdog = new HttpSessionWatchdog();
        this.handlerMap = handlerMap;
        this.tlsServerParameters = tlsServerParameters;
        this.maxChunkContentSize = maxChunkContentSize;
        this.applicationExecutor = new OrderedMemoryAwareThreadPoolExecutor(threadPoolSize, 2048576L, 204857600L);
        this.executionHandler = new ExecutionHandler((Executor)this.applicationExecutor);
    }

    public Map<String, NettyHttpContextHandler> getHttpContextHandlerMap() {
        return this.handlerMap;
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    public NettyHttpContextHandler getNettyHttpHandler(String url) {
        Set<String> keySet = this.handlerMap.keySet();
        for (String key : keySet) {
            if (!url.startsWith(key)) continue;
            return this.handlerMap.get(key);
        }
        return null;
    }

    public void start() {
        if (this.supportSession) {
            new Thread(this.watchdog).start();
        }
    }

    public void shutdown() {
        this.watchdog.stopWatching();
        this.applicationExecutor.shutdown();
        this.allChannels.close();
    }

    public final ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = this.getDefaulHttpChannelPipeline();
        pipeline.addLast("executionHandler", (ChannelHandler)this.executionHandler);
        pipeline.addLast("handler", (ChannelHandler)this.getServletHandler());
        return pipeline;
    }

    protected HttpSessionStore getHttpSessionStore() {
        return new DefaultHttpSessionStore();
    }

    protected NettyHttpServletHandler getServletHandler() {
        NettyHttpServletHandler handler = new NettyHttpServletHandler(this);
        handler.addInterceptor(new ChannelInterceptor());
        if (this.supportSession) {
            handler.addInterceptor(new HttpSessionInterceptor(this.getHttpSessionStore()));
        }
        return handler;
    }

    protected ChannelPipeline getDefaulHttpChannelPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(this.maxChunkContentSize));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("idle", this.idleStateHandler);
        return pipeline;
    }

    private SslHandler configureServerSSLOnDemand() throws Exception {
        if (this.tlsServerParameters != null) {
            SSLEngine sslEngine = SSLUtils.createServerSSLEngine((TLSServerParameters)this.tlsServerParameters);
            return new SslHandler(sslEngine);
        }
        return null;
    }

    private class HttpSessionWatchdog
    implements Runnable {
        private boolean shouldStopWatching;

        private HttpSessionWatchdog() {
        }

        @Override
        public void run() {
            while (!this.shouldStopWatching) {
                try {
                    HttpSessionStore store = NettyHttpServletPipelineFactory.this.getHttpSessionStore();
                    if (store != null) {
                        store.destroyInactiveSessions();
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void stopWatching() {
            this.shouldStopWatching = true;
        }
    }
}

