/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.interceptor;

import java.util.Collection;
import org.apache.cxf.transport.http.netty.server.interceptor.NettyInterceptor;
import org.apache.cxf.transport.http.netty.server.servlet.HttpSessionThreadLocal;
import org.apache.cxf.transport.http.netty.server.servlet.NettyHttpSession;
import org.apache.cxf.transport.http.netty.server.session.HttpSessionStore;
import org.apache.cxf.transport.http.netty.server.util.Utils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class HttpSessionInterceptor
implements NettyInterceptor {
    private boolean sessionRequestedByCookie;

    public HttpSessionInterceptor(HttpSessionStore sessionStore) {
        HttpSessionThreadLocal.setSessionStore(sessionStore);
    }

    @Override
    public void onRequestReceived(ChannelHandlerContext ctx, MessageEvent e) {
        HttpSessionThreadLocal.unset();
        HttpRequest request = (HttpRequest)e.getMessage();
        Collection<Cookie> cookies = Utils.getCookies("JSESSIONID", request);
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String jsessionId = cookie.getValue();
                NettyHttpSession s = HttpSessionThreadLocal.getSessionStore().findSession(jsessionId);
                if (s == null) continue;
                HttpSessionThreadLocal.set(s);
                this.sessionRequestedByCookie = true;
                break;
            }
        }
    }

    @Override
    public void onRequestSuccessed(ChannelHandlerContext ctx, MessageEvent e, HttpResponse response) {
        NettyHttpSession s = HttpSessionThreadLocal.get();
        if (s != null && !this.sessionRequestedByCookie) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            cookieEncoder.addCookie("JSESSIONID", s.getId());
            HttpHeaders.addHeader((HttpMessage)response, (String)"Set-Cookie", (Object)cookieEncoder.encode());
        }
    }

    @Override
    public void onRequestFailed(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.sessionRequestedByCookie = false;
        HttpSessionThreadLocal.unset();
    }
}

