/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cxf.transport.http.netty.server.servlet.ChannelThreadLocal;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletInputStream;
import org.apache.cxf.transport.http.netty.server.servlet.URIParser;
import org.apache.cxf.transport.http.netty.server.util.Utils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyHttpServletRequest
implements HttpServletRequest {
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "javax.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private URIParser uriParser;
    private HttpRequest originalRequest;
    private NettyServletInputStream inputStream;
    private BufferedReader reader;
    private QueryStringDecoder queryStringDecoder;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private CookieDecoder cookieDecoder = new CookieDecoder();
    private String characterEncoding;
    private String contextPath;
    private ChannelHandlerContext channelHandlerContext;

    public NettyHttpServletRequest(HttpRequest request, String contextPath, ChannelHandlerContext ctx) {
        SSLSession session;
        this.originalRequest = request;
        this.contextPath = contextPath;
        this.uriParser = new URIParser(contextPath);
        this.inputStream = new NettyServletInputStream(request);
        this.uriParser.parse(request.getUri());
        this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.inputStream)));
        this.queryStringDecoder = new QueryStringDecoder(request.getUri());
        this.channelHandlerContext = ctx;
        SslHandler sslHandler = (SslHandler)this.channelHandlerContext.getPipeline().get(SslHandler.class);
        if (sslHandler != null && (session = sslHandler.getEngine().getSession()) != null) {
            this.attributes.put(SSL_CIPHER_SUITE_ATTRIBUTE, session.getCipherSuite());
            try {
                this.attributes.put(SSL_PEER_CERT_CHAIN_ATTRIBUTE, session.getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException ex) {
                // empty catch block
            }
        }
    }

    public HttpRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public javax.servlet.http.Cookie[] getCookies() {
        Set cookies;
        String cookieString = this.originalRequest.getHeader("Cookie");
        if (cookieString != null && !(cookies = this.cookieDecoder.decode(cookieString)).isEmpty()) {
            javax.servlet.http.Cookie[] cookiesArray = new javax.servlet.http.Cookie[cookies.size()];
            int indx = 0;
            for (Cookie c : cookies) {
                javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(c.getName(), c.getValue());
                cookie.setComment(c.getComment());
                cookie.setDomain(c.getDomain());
                cookie.setMaxAge(c.getMaxAge());
                cookie.setPath(c.getPath());
                cookie.setSecure(c.isSecure());
                cookie.setVersion(c.getVersion());
                cookiesArray[indx] = cookie;
                ++indx;
            }
            return cookiesArray;
        }
        return null;
    }

    public long getDateHeader(String name) {
        String longVal = this.getHeader(name);
        if (longVal == null) {
            return -1L;
        }
        return Long.parseLong(longVal);
    }

    public String getHeader(String name) {
        return HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)name);
    }

    public Enumeration getHeaderNames() {
        return Utils.enumeration(this.originalRequest.getHeaderNames());
    }

    public Enumeration getHeaders(String name) {
        return Utils.enumeration(this.originalRequest.getHeaders(name));
    }

    public int getIntHeader(String name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.originalRequest, (String)name, (int)-1);
    }

    public String getMethod() {
        return this.originalRequest.getMethod().getName();
    }

    public String getQueryString() {
        return this.uriParser.getQueryString();
    }

    public String getRequestURI() {
        return this.uriParser.getRequestUri();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        String urlPath = this.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443) {
            url.append(':');
            url.append(this.getServerPort());
        }
        url.append(urlPath);
        return url;
    }

    public int getContentLength() {
        return (int)HttpHeaders.getContentLength((HttpMessage)this.originalRequest, (long)-1L);
    }

    public String getContentType() {
        return HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)"Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = Utils.getCharsetFromContentType(this.getContentType());
        }
        return this.characterEncoding;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values != null ? values[0] : null;
    }

    public Map getParameterMap() {
        return this.queryStringDecoder.getParameters();
    }

    public Enumeration getParameterNames() {
        return Utils.enumerationFromKeys(this.queryStringDecoder.getParameters());
    }

    public String[] getParameterValues(String name) {
        List values = (List)this.queryStringDecoder.getParameters().get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public String getProtocol() {
        return this.originalRequest.getProtocolVersion().toString();
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return Utils.enumerationFromKeys(this.attributes);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public BufferedReader getReader() throws IOException {
        return this.reader;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public String getPathInfo() {
        return this.uriParser.getPathInfo();
    }

    public Locale getLocale() {
        String locale = HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)"Accept-Language", (String)DEFAULT_LOCALE.toString());
        return new Locale(locale);
    }

    public String getRemoteAddr() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getRemoteAddress();
        return addr.getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getRemoteAddress();
        return addr.getHostName();
    }

    public int getRemotePort() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getRemoteAddress();
        return addr.getPort();
    }

    public String getServerName() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getLocalAddress();
        return addr.getHostName();
    }

    public int getServerPort() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getLocalAddress();
        return addr.getPort();
    }

    public String getServletPath() {
        String servletPath = this.uriParser.getServletPath();
        if ("/".equals(servletPath)) {
            return "";
        }
        return servletPath;
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public boolean isSecure() {
        return ChannelThreadLocal.get().getPipeline().get(SslHandler.class) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public String getLocalAddr() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getLocalAddress();
        return addr.getAddress().getHostAddress();
    }

    public String getLocalName() {
        return this.getServerName();
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public Enumeration getLocales() {
        Collection<Locale> locales = Utils.parseAcceptLanguageHeader(HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)"Accept-Language"));
        if (locales == null || locales.isEmpty()) {
            locales = new ArrayList<Locale>();
            locales.add(Locale.getDefault());
        }
        return Utils.enumeration(locales);
    }

    public String getAuthType() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public String getRealPath(String path) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }
}

