/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class NettyServletOutputStream
extends ServletOutputStream {
    private HttpResponse response;
    private ChannelBufferOutputStream out;
    private boolean flushed;

    public NettyServletOutputStream(HttpResponse response) {
        this.response = response;
        this.out = new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer());
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        this.out.write(b, offset, len);
    }

    public void flush() throws IOException {
        this.response.setContent(this.out.buffer());
        this.flushed = true;
    }

    public void resetBuffer() {
        this.out.buffer().clear();
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public int getBufferSize() {
        return this.out.buffer().capacity();
    }
}

