/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

public class JAXRSDefaultFaultOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSDefaultFaultOutInterceptor.class);

    public JAXRSDefaultFaultOutInterceptor() {
        super("marshal");
    }

    public JAXRSDefaultFaultOutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        if (this.mustPropogateException(message)) {
            throw (Fault)message.getContent(Exception.class);
        }
        Fault f = (Fault)message.getContent(Exception.class);
        message.put((Object)Message.RESPONSE_CODE, (Object)f.getStatusCode());
        NSStack nsStack = new NSStack();
        nsStack.push();
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        try {
            nsStack.add("http://cxf.apache.org/bindings/xformat");
            String prefix = nsStack.getPrefix("http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"XMLFault", (String)"http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"faultstring", (String)"http://cxf.apache.org/bindings/xformat");
            Throwable t = f.getCause();
            writer.writeCharacters(t == null ? f.getMessage() : t.toString());
            writer.writeEndElement();
            if (f.getDetail() != null) {
                StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"detail", (String)"http://cxf.apache.org/bindings/xformat");
                StaxUtils.writeNode((Node)DOMUtils.getChild((Node)f.getDetail(), (int)1), (XMLStreamWriter)writer, (boolean)false);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }

    public void handleFault(Message message) throws Fault {
        if (this.mustPropogateException(message)) {
            throw (Fault)message.getContent(Exception.class);
        }
    }

    protected boolean mustPropogateException(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get((Object)Message.PROPOGATE_EXCEPTION));
    }
}

