/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.coloc;

import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.coloc.ColocInFaultObserver;
import org.apache.cxf.binding.coloc.ColocMessageObserver;
import org.apache.cxf.binding.coloc.ColocUtil;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;

public class ColocOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ColocOutInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(ClientImpl.class);
    private static final String COLOCATED = Message.class.getName() + ".COLOCATED";
    private MessageObserver colocObserver;
    private Bus bus;

    public ColocOutInterceptor() {
        super("post-logical");
    }

    public ColocOutInterceptor(Bus b) {
        super("post-logical");
        this.bus = b;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        ServerRegistry registry;
        if (this.bus == null) {
            this.bus = message.getExchange().get(Bus.class);
            if (this.bus == null) {
                this.bus = BusFactory.getDefaultBus(false);
            }
            if (this.bus == null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("BUS_NOT_FOUND", BUNDLE, new Object[0]));
            }
        }
        if ((registry = this.bus.getExtension(ServerRegistry.class)) == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("SERVER_REGISTRY_NOT_FOUND", BUNDLE, new Object[0]));
        }
        Exchange exchange = message.getExchange();
        Endpoint senderEndpoint = exchange.get(Endpoint.class);
        if (senderEndpoint == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("ENDPOINT_NOT_FOUND", BUNDLE, new Object[0]));
        }
        BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
        if (boi == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("OPERATIONINFO_NOT_FOUND", BUNDLE, new Object[0]));
        }
        Server srv = this.isColocated(registry.getServers(), senderEndpoint, boi);
        if (srv != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Operation:" + boi.getName() + " dispatched as colocated call.");
            }
            InterceptorChain outChain = message.getInterceptorChain();
            outChain.abort();
            exchange.put(Bus.class, this.bus);
            message.put(COLOCATED, Boolean.TRUE);
            message.put("javax.xml.ws.wsdl.operation", boi.getName());
            message.put("javax.xml.ws.wsdl.interface", boi.getBinding().getInterface().getName());
            this.invokeColocObserver(message, srv.getEndpoint());
            if (!exchange.isOneWay()) {
                this.invokeInboundChain(exchange, senderEndpoint);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Operation:" + boi.getName() + " dispatched as remote call.");
            }
            message.put(COLOCATED, Boolean.FALSE);
        }
    }

    protected void invokeColocObserver(Message outMsg, Endpoint inboundEndpoint) {
        if (this.colocObserver == null) {
            this.colocObserver = new ColocMessageObserver(inboundEndpoint, this.bus);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Invoke on Coloc Observer.");
        }
        this.colocObserver.onMessage(outMsg);
    }

    protected void invokeInboundChain(Exchange ex, Endpoint ep) {
        Message m = this.getInBoundMessage(ex);
        Message inMsg = ep.getBinding().createMessage();
        MessageImpl.copyContent(m, inMsg);
        inMsg.putAll(m);
        inMsg.put("org.apache.cxf.client", Boolean.TRUE);
        inMsg.put("org.apache.cxf.message.inbound", Boolean.TRUE);
        inMsg.setExchange(ex);
        Exception exc = inMsg.getContent(Exception.class);
        if (exc != null) {
            ex.setInFaultMessage(inMsg);
            ColocInFaultObserver observer = new ColocInFaultObserver(this.bus);
            observer.onMessage(inMsg);
        } else {
            ex.setInMessage(inMsg);
            PhaseManager pm = this.bus.getExtension(PhaseManager.class);
            TreeSet<Phase> phases = new TreeSet<Phase>(pm.getInPhases());
            ColocUtil.setPhases(phases, "user-logical", "pre-invoke");
            InterceptorChain chain = ColocUtil.getInInterceptorChain(ex, phases);
            inMsg.setInterceptorChain(chain);
            chain.doIntercept(inMsg);
        }
        ex.put("exchange.finished", Boolean.TRUE);
    }

    protected Message getInBoundMessage(Exchange ex) {
        return ex.getInFaultMessage() != null ? ex.getInFaultMessage() : ex.getInMessage();
    }

    protected void setMessageObserver(MessageObserver observer) {
        this.colocObserver = observer;
    }

    protected Server isColocated(List<Server> servers, Endpoint endpoint, BindingOperationInfo boi) {
        if (servers != null) {
            Service senderService = endpoint.getService();
            EndpointInfo senderEI = endpoint.getEndpointInfo();
            for (Server s : servers) {
                BindingOperationInfo receiverOI;
                Endpoint receiverEndpoint = s.getEndpoint();
                Service receiverService = receiverEndpoint.getService();
                EndpointInfo receiverEI = receiverEndpoint.getEndpointInfo();
                if (!receiverService.getName().equals(senderService.getName()) || !receiverEI.getName().equals(senderEI.getName()) || (receiverOI = receiverEI.getBinding().getOperation(boi.getName())) == null || !this.isCompatibleOperationInfo(boi, receiverOI)) continue;
                return s;
            }
        }
        return null;
    }

    protected boolean isSameOperationInfo(BindingOperationInfo sender, BindingOperationInfo receiver) {
        return ColocUtil.isSameOperationInfo(sender.getOperationInfo(), receiver.getOperationInfo());
    }

    protected boolean isCompatibleOperationInfo(BindingOperationInfo sender, BindingOperationInfo receiver) {
        return ColocUtil.isCompatibleOperationInfo(sender.getOperationInfo(), receiver.getOperationInfo());
    }

    public void setExchangeProperties(Exchange exchange, Endpoint ep) {
        exchange.put(Endpoint.class, ep);
        exchange.put(Service.class, ep.getService());
        exchange.put(Binding.class, ep.getBinding());
        exchange.put(Bus.class, this.bus == null ? BusFactory.getDefaultBus(false) : this.bus);
    }
}

