/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http.netty.server.NettyHttpContextHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServletPipelineFactory;
import org.apache.cxf.transport.http.netty.server.ServerEngine;
import org.apache.cxf.transport.http.netty.server.ThreadingParameters;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class NettyHttpServerEngine
implements ServerEngine {
    private int port;
    private String host;
    private String protocol = "http";
    private volatile Channel serverChannel;
    private NettyHttpServletPipelineFactory servletPipeline;
    private ServerBootstrap bootstrap;
    private Timer timer = new HashedWheelTimer();
    private Map<String, NettyHttpContextHandler> handlerMap = new ConcurrentHashMap<String, NettyHttpContextHandler>();
    private TLSServerParameters tlsServerParameters;
    private ThreadingParameters threadingParameters = new ThreadingParameters();
    private int readIdleTime = 60;
    private int writeIdleTime = 30;
    private int maxChunkContentSize = 0x100000;
    private boolean sessionSupport;
    private ExecutorService bossExecutor;
    private ExecutorService workerExecutor;

    public NettyHttpServerEngine() {
    }

    public NettyHttpServerEngine(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @PostConstruct
    public void finalizeConfig() {
    }

    public void setTlsServerParameters(TLSServerParameters params) {
        this.tlsServerParameters = params;
    }

    public TLSServerParameters getTlsServerParameters() {
        return this.tlsServerParameters;
    }

    public void setThreadingParameters(ThreadingParameters params) {
        this.threadingParameters = params;
    }

    public ThreadingParameters getThreadingParameters() {
        return this.threadingParameters;
    }

    protected Channel startServer() {
        this.bossExecutor = Executors.newCachedThreadPool();
        this.workerExecutor = Executors.newCachedThreadPool();
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor));
        this.bootstrap.setOption("reuseAddress", (Object)true);
        IdleStateHandler idleStateHandler = new IdleStateHandler(this.timer, this.getReadIdleTime(), this.getWriteIdleTime(), 0);
        this.servletPipeline = new NettyHttpServletPipelineFactory(this.tlsServerParameters, this.sessionSupport, this.threadingParameters.getThreadPoolSize(), this.maxChunkContentSize, this.handlerMap, idleStateHandler);
        this.servletPipeline.start();
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this.servletPipeline);
        InetSocketAddress address = null;
        address = this.host == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port);
        return this.bootstrap.bind((SocketAddress)address);
    }

    @Override
    public void addServant(URL url, NettyHttpHandler handler) {
        if (this.serverChannel == null) {
            this.serverChannel = this.startServer();
        }
        handler.setName(url.getPath());
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        NettyHttpContextHandler contextHandler = this.handlerMap.get(contextName);
        if (contextHandler == null) {
            contextHandler = new NettyHttpContextHandler(contextName);
            this.handlerMap.put(contextName, contextHandler);
        }
        contextHandler.addNettyHttpHandler(handler);
    }

    @Override
    public void removeServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        NettyHttpContextHandler contextHandler = this.handlerMap.get(contextName);
        if (contextHandler != null) {
            contextHandler.removeNettyHttpHandler(url.getPath());
            if (contextHandler.isEmpty()) {
                this.handlerMap.remove(contextName);
            }
        }
    }

    @Override
    public NettyHttpHandler getServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        NettyHttpContextHandler contextHandler = this.handlerMap.get(contextName);
        if (contextHandler != null) {
            return contextHandler.getNettyHttpHandler(url.getPath());
        }
        return null;
    }

    public void shutdown() {
        this.timer.stop();
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
        }
        if (this.servletPipeline != null) {
            this.servletPipeline.shutdown();
        }
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
        }
        if (this.workerExecutor != null) {
            this.workerExecutor.shutdown();
        }
    }

    public int getReadIdleTime() {
        return this.readIdleTime;
    }

    public void setReadIdleTime(int readIdleTime) {
        this.readIdleTime = readIdleTime;
    }

    public int getWriteIdleTime() {
        return this.writeIdleTime;
    }

    public void setWriteIdleTime(int writeIdleTime) {
        this.writeIdleTime = writeIdleTime;
    }

    public boolean isSessionSupport() {
        return this.sessionSupport;
    }

    public void setSessionSupport(boolean session) {
        this.sessionSupport = session;
    }

    public int getMaxChunkContentSize() {
        return this.maxChunkContentSize;
    }

    public void setMaxChunkContentSize(int maxChunkContentSize) {
        this.maxChunkContentSize = maxChunkContentSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }
}

