/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.services;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.wsn.AbstractEndpoint;
import org.apache.cxf.wsn.EndpointManager;
import org.apache.cxf.wsn.EndpointRegistrationException;
import org.apache.cxf.wsn.util.WSNHelper;
import org.w3c.dom.Element;

public class JaxwsEndpointManager
implements EndpointManager {
    protected MBeanServer mbeanServer;

    public void setMBeanServer(MBeanServer s) {
        this.mbeanServer = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint register(String address, Object service) throws EndpointRegistrationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            if (WSNHelper.getInstance().setClassLoader()) {
                Thread.currentThread().setContextClassLoader(JaxwsEndpointManager.class.getClassLoader());
            }
            String bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
            if (this.isCXF()) {
                bindingId = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
            }
            Endpoint endpoint = Endpoint.create((String)bindingId, (Object)service);
            endpoint.publish(address);
            try {
                ObjectName on;
                if (this.mbeanServer != null && service instanceof AbstractEndpoint && (on = ((AbstractEndpoint)service).getMBeanName()) != null) {
                    this.mbeanServer.registerMBean(service, on);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Endpoint endpoint2 = endpoint;
            return endpoint2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private boolean isCXF() {
        return Provider.provider().getClass().getName().contains(".cxf");
    }

    @Override
    public void unregister(Endpoint endpoint, Object service) throws EndpointRegistrationException {
        try {
            ObjectName on;
            if (this.mbeanServer != null && service instanceof AbstractEndpoint && (on = ((AbstractEndpoint)service).getMBeanName()) != null) {
                this.mbeanServer.unregisterMBean(on);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        endpoint.stop();
    }

    @Override
    public W3CEndpointReference getEpr(Endpoint endpoint) {
        return (W3CEndpointReference)endpoint.getEndpointReference(W3CEndpointReference.class, new Element[0]);
    }
}

