/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transport.http.netty.client.CxfResponseCallBack;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientPipelineFactory;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientRequest;
import org.apache.cxf.transport.http.netty.client.NettyHttpConduitFactory;
import org.apache.cxf.transport.https.CertificateHostnameVerifier;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.version.Version;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyHttpConduit
extends URLConnectionHTTPConduit {
    public static final String USE_ASYNC = "use.async.http.conduit";
    final NettyHttpConduitFactory factory;
    private final ClientBootstrap bootstrap;

    public NettyHttpConduit(Bus b, EndpointInfo ei, EndpointReferenceType t, NettyHttpConduitFactory conduitFactory) throws IOException {
        super(b, ei, t);
        this.factory = conduitFactory;
        this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory(this.factory.getBossExecutor(), this.factory.getWorkExecutor()));
    }

    public NettyHttpConduitFactory getNettyHttpConduitFactory() {
        return this.factory;
    }

    public void close() {
        super.close();
        this.bootstrap.shutdown();
    }

    protected void setupConnection(Message message, URI uri, HTTPClientPolicy csPolicy) throws IOException {
        String s;
        String uriString = uri.toString();
        if (uriString.startsWith("netty://")) {
            try {
                uri = new URI(uriString.substring(8));
            }
            catch (URISyntaxException ex) {
                throw new MalformedURLException("unsupport uri: " + uriString);
            }
        }
        if (!"http".equals(s = uri.getScheme()) && !"https".equals(s)) {
            throw new MalformedURLException("unknown protocol: " + s);
        }
        if (StringUtils.isEmpty((String)uri.getPath())) {
            uri = uri.resolve("/");
        }
        message.put((Object)"http.scheme", (Object)uri.getScheme());
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (httpRequestMethod == null) {
            httpRequestMethod = "POST";
            message.put((Object)"org.apache.cxf.request.method", (Object)httpRequestMethod);
        }
        NettyHttpClientRequest request = new NettyHttpClientRequest(uri, httpRequestMethod);
        int ctimeout = NettyHttpConduit.determineConnectionTimeout((Message)message, (HTTPClientPolicy)csPolicy);
        int rtimeout = NettyHttpConduit.determineReceiveTimeout((Message)message, (HTTPClientPolicy)csPolicy);
        request.setConnectionTimeout(ctimeout);
        request.setReceiveTimeout(rtimeout);
        request.getRequest().setChunked(true);
        request.getRequest().setHeader("Content-Type", (Object)((String)message.get((Object)"Content-Type")));
        message.put(NettyHttpClientRequest.class, (Object)request);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new NettyHttpClientPipelineFactory(this.getTlsClientParameters()));
    }

    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        NettyHttpClientRequest entity = (NettyHttpClientRequest)message.get(NettyHttpClientRequest.class);
        NettyWrappedOutputStream out = new NettyWrappedOutputStream(message, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName(), entity.getUri());
        entity.getRequest().setContent(out.getOutBuffer());
        return out;
    }

    public class NettyWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream {
        final HTTPClientPolicy csPolicy;
        NettyHttpClientRequest entity;
        volatile HttpResponse httpResponse;
        volatile Throwable exception;
        volatile Channel channel;
        volatile SSLSession session;
        boolean isAsync;
        ChannelBuffer outBuffer;
        OutputStream outputStream;

        protected NettyWrappedOutputStream(Message message, boolean possibleRetransmit, boolean isChunking, int chunkThreshold, String conduitName, URI url) {
            super((HTTPConduit)NettyHttpConduit.this, message, possibleRetransmit, isChunking, chunkThreshold, conduitName, url);
            this.csPolicy = NettyHttpConduit.this.getClient(message);
            this.entity = (NettyHttpClientRequest)message.get(NettyHttpClientRequest.class);
            int bufSize = this.csPolicy.getChunkLength() > 0 ? this.csPolicy.getChunkLength() : 16320;
            this.outBuffer = ChannelBuffers.dynamicBuffer((int)bufSize);
            this.outputStream = new ChannelBufferOutputStream(this.outBuffer);
        }

        protected ChannelBuffer getOutBuffer() {
            return this.outBuffer;
        }

        protected synchronized HttpResponse getHttpResponse() throws IOException {
            while (this.httpResponse == null) {
                if (this.exception == null) {
                    try {
                        ((Object)((Object)this)).wait(this.entity.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.httpResponse != null) continue;
                if (this.exception != null) {
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new IOException(this.exception);
                }
                throw new SocketTimeoutException("Read Timeout");
            }
            return this.httpResponse;
        }

        protected synchronized Channel getChannel() throws IOException {
            while (this.channel == null) {
                if (this.exception == null) {
                    try {
                        ((Object)((Object)this)).wait(this.entity.getConnectionTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.channel != null) continue;
                if (this.exception != null) {
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new IOException(this.exception);
                }
                throw new SocketTimeoutException("Connection Timeout");
            }
            return this.channel;
        }

        protected void setupWrappedStream() throws IOException {
            this.connect(true);
            this.wrappedStream = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    NettyWrappedOutputStream.this.outputStream.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    NettyWrappedOutputStream.this.outputStream.write(b);
                }

                @Override
                public void close() throws IOException {
                    ChannelFutureListener listener = new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                NettyWrappedOutputStream.this.setException(future.getCause());
                            }
                        }
                    };
                    ChannelFuture channelFuture = NettyWrappedOutputStream.this.getChannel().write((Object)NettyWrappedOutputStream.this.entity);
                    channelFuture.addListener(listener);
                    NettyWrappedOutputStream.this.outputStream.close();
                }
            };
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(this.wrappedStream);
                this.wrappedStream = this.cachedStream;
            }
        }

        protected TLSClientParameters findTLSClientParameters() {
            TLSClientParameters clientParameters = (TLSClientParameters)this.outMessage.get(TLSClientParameters.class);
            if (clientParameters == null) {
                clientParameters = NettyHttpConduit.this.getTlsClientParameters();
            }
            if (clientParameters == null) {
                clientParameters = new TLSClientParameters();
            }
            return clientParameters;
        }

        protected void connect(boolean output) {
            if (this.url.getScheme().equals("https")) {
                TLSClientParameters clientParameters = this.findTLSClientParameters();
                NettyHttpConduit.this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new NettyHttpClientPipelineFactory(clientParameters));
            } else {
                NettyHttpConduit.this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new NettyHttpClientPipelineFactory(null));
            }
            ChannelFuture connFuture = NettyHttpConduit.this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.url.getHost(), this.url.getPort()));
            ChannelFutureListener listener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        NettyWrappedOutputStream.this.setChannel(future.getChannel());
                        SslHandler sslHandler = (SslHandler)NettyWrappedOutputStream.this.channel.getPipeline().get(SslHandler.class);
                        if (sslHandler != null) {
                            NettyWrappedOutputStream.this.session = sslHandler.getEngine().getSession();
                        }
                    } else {
                        NettyWrappedOutputStream.this.setException((Exception)future.getCause());
                    }
                }
            };
            connFuture.addListener(listener);
            if (!output) {
                this.entity.getRequest().removeHeader("Transfer-Encoding");
                this.entity.getRequest().removeHeader("Content-Type");
                this.entity.getRequest().setContent(null);
            }
            CxfResponseCallBack callBack = new CxfResponseCallBack(){

                @Override
                public void responseReceived(HttpResponse response) {
                    NettyWrappedOutputStream.this.setHttpResponse(response);
                }
            };
            this.entity.setCxfResponseCallback(callBack);
        }

        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            if ("http".equals(this.outMessage.get((Object)"http.scheme"))) {
                return null;
            }
            this.connect(true);
            TLSClientParameters tlsClientParameters = this.findTLSClientParameters();
            HostnameVerifier verifier = tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier() ? HttpsURLConnection.getDefaultHostnameVerifier() : (tlsClientParameters.isDisableCNCheck() ? CertificateHostnameVerifier.ALLOW_ALL : CertificateHostnameVerifier.DEFAULT);
            if (!verifier.verify(this.url.getHost(), this.session)) {
                throw new IOException("Could not verify host " + this.url.getHost());
            }
            String method = (String)this.outMessage.get((Object)"org.apache.cxf.request.method");
            String cipherSuite = null;
            Certificate[] localCerts = null;
            Principal principal = null;
            Certificate[] serverCerts = null;
            Principal peer = null;
            if (this.session != null) {
                cipherSuite = this.session.getCipherSuite();
                localCerts = this.session.getLocalCertificates();
                principal = this.session.getLocalPrincipal();
                serverCerts = this.session.getPeerCertificates();
                peer = this.session.getPeerPrincipal();
            }
            return new HttpsURLConnectionInfo(this.url, method, cipherSuite, localCerts, principal, serverCerts, peer);
        }

        protected void setProtocolHeaders() throws IOException {
            Headers h = new Headers(this.outMessage);
            this.entity.getRequest().setHeader("Content-Type", (Object)h.determineContentType());
            boolean addHeaders = MessageUtils.isTrue((Object)this.outMessage.getContextualProperty("org.apache.cxf.http.add-headers"));
            for (Map.Entry header : h.headerMap().entrySet()) {
                if ("Content-Type".equalsIgnoreCase((String)header.getKey())) continue;
                if (addHeaders || "Cookie".equalsIgnoreCase((String)header.getKey())) {
                    for (String s : (List)header.getValue()) {
                        this.entity.getRequest().addHeader("Cookie", (Object)s);
                    }
                } else if (!"Content-Length".equalsIgnoreCase((String)header.getKey())) {
                    StringBuilder b = new StringBuilder();
                    for (int i = 0; i < ((List)header.getValue()).size(); ++i) {
                        b.append((String)((List)header.getValue()).get(i));
                        if (i + 1 >= ((List)header.getValue()).size()) continue;
                        b.append(',');
                    }
                    this.entity.getRequest().setHeader((String)header.getKey(), (Object)b.toString());
                }
                if (this.entity.getRequest().containsHeader("User-Agent")) continue;
                this.entity.getRequest().setHeader("User-Agent", (Object)Version.getCompleteVersionString());
            }
        }

        protected void setFixedLengthStreamingMode(int i) {
            this.entity.getRequest().setHeader("Content-Length", (Object)i);
            this.entity.getRequest().setChunked(false);
        }

        protected int getResponseCode() throws IOException {
            return this.getHttpResponse().getStatus().getCode();
        }

        protected String getResponseMessage() throws IOException {
            return this.getHttpResponse().getStatus().getReasonPhrase();
        }

        protected void updateResponseHeaders(Message inMessage) throws IOException {
            Headers h = new Headers(inMessage);
            inMessage.put((Object)"Content-Type", (Object)this.readHeaders(h));
            NettyHttpConduit.this.cookies.readFromHeaders(h);
        }

        private String readHeaders(Headers h) throws IOException {
            Set headerNames = this.getHttpResponse().getHeaderNames();
            String ct = null;
            for (String name : headerNames) {
                List s = this.getHttpResponse().getHeaders(name);
                h.headerMap().put(name, s);
                if (!"Content-Type".equalsIgnoreCase(name)) continue;
                ct = this.getHttpResponse().getHeader(name);
            }
            return ct;
        }

        protected void handleResponseAsync() throws IOException {
            this.isAsync = true;
        }

        protected void closeInputStream() throws IOException {
            this.getHttpResponse().getContent().clear();
        }

        protected boolean usingProxy() {
            return false;
        }

        protected InputStream getInputStream() throws IOException {
            return new ChannelBufferInputStream(this.getHttpResponse().getContent());
        }

        protected InputStream getPartialResponse() throws IOException {
            InputStream in = null;
            int responseCode = this.getResponseCode();
            if (responseCode == 202 || responseCode == 200) {
                boolean isEofTerminated;
                String head = this.httpResponse.getHeader("Content-Length");
                int cli = 0;
                if (head != null) {
                    cli = Integer.parseInt(head);
                }
                boolean isChunked = (head = this.httpResponse.getHeader("Transfer-Encoding")) != null && "chunked".equalsIgnoreCase(head);
                head = this.httpResponse.getHeader("Connection");
                boolean bl = isEofTerminated = head != null && "close".equalsIgnoreCase(head);
                if (cli > 0) {
                    in = this.getInputStream();
                } else if (isChunked || isEofTerminated) {
                    try {
                        PushbackInputStream pin = new PushbackInputStream(this.getInputStream());
                        int c = pin.read();
                        if (c != -1) {
                            pin.unread((byte)c);
                            in = pin;
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            return in;
        }

        protected void setupNewConnection(String newURL) throws IOException {
            this.httpResponse = null;
            this.isAsync = false;
            this.exception = null;
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            try {
                this.url = new URI(newURL);
                NettyHttpConduit.this.setupConnection(this.outMessage, this.url, this.csPolicy);
                this.entity = (NettyHttpClientRequest)this.outMessage.get(NettyHttpClientRequest.class);
                this.outBuffer.clear();
                this.outputStream = new ChannelBufferOutputStream(this.outBuffer);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        protected void retransmitStream() throws IOException {
            this.cachingForRetransmission = false;
            this.setupWrappedStream();
            this.cachedStream.writeCacheTo(this.wrappedStream);
            this.wrappedStream.flush();
            this.wrappedStream.close();
        }

        protected void updateCookiesBeforeRetransmit() throws IOException {
            Headers h = new Headers();
            this.readHeaders(h);
            NettyHttpConduit.this.cookies.readFromHeaders(h);
        }

        public void thresholdReached() throws IOException {
            this.entity.getRequest().setChunked(true);
        }

        protected synchronized void setHttpResponse(HttpResponse r) {
            this.httpResponse = r;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((Object)((Object)this)).notifyAll();
        }

        protected synchronized void setException(Throwable ex) {
            this.exception = ex;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            ((Object)((Object)this)).notifyAll();
        }

        protected synchronized void setChannel(Channel ch) {
            this.channel = ch;
            ((Object)((Object)this)).notifyAll();
        }
    }
}

