/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.AbstractServiceProviderFilter;
import org.apache.cxf.rs.security.saml.sso.SamlRequestInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.util.DOM2Writer;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlPostBindingFilter
extends AbstractServiceProviderFilter {
    private boolean useDeflateEncoding;

    public void setUseDeflateEncoding(boolean useDeflateEncoding) {
        this.useDeflateEncoding = useDeflateEncoding;
    }

    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        if (this.checkSecurityContext(m)) {
            return null;
        }
        try {
            SamlRequestInfo info = this.createSamlRequestInfo(m);
            info.setIdpServiceAddress(this.getIdpServiceAddress());
            String contextCookie = this.createCookie("RelayState", info.getRelayState(), info.getWebAppContext(), info.getWebAppDomain());
            new MessageContextImpl(m).getHttpServletResponse().addHeader("Set-Cookie", contextCookie);
            return Response.ok((Object)info).type("text/html").header("Cache-Control", (Object)"no-cache, no-store").header("Pragma", (Object)"no-cache").build();
        }
        catch (Exception ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    @Override
    protected String encodeAuthnRequest(Element authnRequest) throws IOException {
        String requestMessage = DOM2Writer.nodeToString((Node)authnRequest);
        byte[] deflatedBytes = null;
        if (this.useDeflateEncoding) {
            DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
            deflatedBytes = encoder.deflateToken(requestMessage.getBytes("UTF-8"));
        } else {
            deflatedBytes = requestMessage.getBytes("UTF-8");
        }
        return Base64Utility.encode((byte[])deflatedBytes);
    }

    @Override
    protected void signAuthnRequest(AuthnRequest authnRequest) throws Exception {
        Crypto crypto = this.getSignatureCrypto();
        if (crypto == null) {
            LOG.fine("No crypto instance of properties file configured for signature");
            throw new InternalServerErrorException();
        }
        String signatureUser = this.getSignatureUsername();
        if (signatureUser == null) {
            LOG.fine("No user configured for signature");
            throw new InternalServerErrorException();
        }
        CallbackHandler callbackHandler = this.getCallbackHandler();
        if (callbackHandler == null) {
            LOG.fine("No CallbackHandler configured to supply a password for signature");
            throw new InternalServerErrorException();
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(signatureUser);
        X509Certificate[] issuerCerts = crypto.getX509Certificates(cryptoType);
        if (issuerCerts == null) {
            throw new WSSecurityException("No issuer certs were found to sign the request using name: " + signatureUser);
        }
        String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
        LOG.fine("automatic sig algo detection: " + pubKeyAlgo);
        if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        LOG.fine("Using Signature algorithm " + sigAlgo);
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(signatureUser, 3)};
        callbackHandler.handle((Callback[])cb);
        String password = cb[0].getPassword();
        PrivateKey privateKey = null;
        try {
            privateKey = crypto.getPrivateKey(signatureUser, password);
        }
        catch (Exception ex) {
            throw new WSSecurityException(ex.getMessage(), (Throwable)ex);
        }
        Signature signature = OpenSAMLUtil.buildSignature();
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm(sigAlgo);
        BasicX509Credential signingCredential = new BasicX509Credential();
        signingCredential.setEntityCertificate(issuerCerts[0]);
        signingCredential.setPrivateKey(privateKey);
        signature.setSigningCredential((Credential)signingCredential);
        X509KeyInfoGeneratorFactory kiFactory = new X509KeyInfoGeneratorFactory();
        kiFactory.setEmitEntityCertificate(true);
        try {
            KeyInfo keyInfo = kiFactory.newInstance().generate((Credential)signingCredential);
            signature.setKeyInfo(keyInfo);
        }
        catch (SecurityException ex) {
            throw new WSSecurityException("Error generating KeyInfo from signing credential", (Throwable)ex);
        }
        AuthnRequest signableObject = authnRequest;
        signableObject.setSignature(signature);
        signableObject.releaseDOM();
        signableObject.releaseChildrenDOM(true);
    }
}

