/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public abstract class AbstractOAuthService {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractOAuthService.class);
    private MessageContext mc;
    private OAuthDataProvider dataProvider;
    private boolean blockUnsecureRequests;
    private boolean writeOptionalParameters = true;

    public void setWriteOptionalParameters(boolean write) {
        this.writeOptionalParameters = write;
    }

    public boolean isWriteOptionalParameters() {
        return this.writeOptionalParameters;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public OAuthDataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected MultivaluedMap<String, String> getQueryParameters() {
        return this.getMessageContext().getUriInfo().getQueryParameters();
    }

    protected Client getValidClient(MultivaluedMap<String, String> params) {
        return this.getValidClient((String)params.getFirst((Object)"client_id"));
    }

    protected Client getValidClient(String clientId) throws OAuthServiceException {
        Client client = null;
        if (clientId != null) {
            client = this.dataProvider.getClient(clientId);
        }
        return client;
    }

    protected void checkTransportSecurity() {
        if (!this.mc.getSecurityContext().isSecure()) {
            LOG.warning("Unsecure HTTP, Transport Layer Security is recommended");
            if (this.blockUnsecureRequests) {
                throw new BadRequestException();
            }
        }
    }

    protected void reportInvalidRequestError(String errorDescription) {
        this.reportInvalidRequestError(errorDescription, MediaType.APPLICATION_JSON_TYPE);
    }

    protected void reportInvalidRequestError(String errorDescription, MediaType mt) {
        OAuthError error = new OAuthError("invalid_request", errorDescription);
        this.reportInvalidRequestError(error, mt);
    }

    protected void reportInvalidRequestError(OAuthError entity) {
        this.reportInvalidRequestError(entity, MediaType.APPLICATION_JSON_TYPE);
    }

    protected void reportInvalidRequestError(OAuthError entity, MediaType mt) {
        Response.ResponseBuilder rb = Response.status((int)400);
        if (mt != null) {
            rb.type(mt);
        }
        throw new BadRequestException(rb.entity((Object)entity).build());
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }
}

