/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.wsdl.BindingInput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.service.model.ServiceSchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.cxf.wsdl.WSDLExtensionLoader;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.SchemaSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@NoJSR250Annotations(unlessNull={"bus"})
public class WSDLManagerImpl
implements WSDLManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLManagerImpl.class);
    private static final String EXTENSIONS_RESOURCE = "META-INF/cxf/extensions.xml";
    private static final String EXTENSIONS_RESOURCE_COMPAT = "META-INF/extensions.xml";
    final ExtensionRegistry registry;
    final WSDLFactory factory;
    final Map<Object, Definition> definitionsMap;
    final Map<Object, ServiceSchemaInfo> schemaCacheMap;
    private boolean disableSchemaCache;
    private Bus bus;

    public WSDLManagerImpl() throws BusException {
        this(null);
    }

    private WSDLManagerImpl(Bus b) throws BusException {
        try {
            this.factory = WSDLFactory.newInstance();
            this.registry = this.factory.newPopulatedExtensionRegistry();
            this.registry.registerSerializer(Types.class, WSDLConstants.QNAME_SCHEMA, (ExtensionSerializer)new SchemaSerializer());
            QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
            this.registry.registerDeserializer(MIMEPart.class, header, this.registry.queryDeserializer(BindingInput.class, header));
            this.registry.registerSerializer(MIMEPart.class, header, this.registry.querySerializer(BindingInput.class, header));
            Class<?> clazz = this.registry.createExtension(BindingInput.class, header).getClass();
            this.registry.mapExtensionTypes(MIMEPart.class, header, clazz);
            this.addExtensionAttributeTypes(this.registry);
        }
        catch (WSDLException e) {
            throw new BusException((Throwable)e);
        }
        this.definitionsMap = new CacheMap();
        this.schemaCacheMap = new CacheMap();
        this.registerInitialExtensions(b);
        this.setBus(b);
    }

    @Resource
    public final void setBus(Bus b) {
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension((Object)this, WSDLManager.class);
            ConfiguredBeanLocator loc = (ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class);
            if (loc != null) {
                loc.getBeansOfType(WSDLExtensionLoader.class);
            }
        }
    }

    public WSDLFactory getWSDLFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Definition> getDefinitions() {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            return Collections.unmodifiableMap(this.definitionsMap);
        }
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition(URL url) throws WSDLException {
        String urlString = url.toString();
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
            if (this.definitionsMap.containsKey(urlString)) {
                return this.definitionsMap.get(urlString);
            }
        }
        Definition def = this.loadDefinition(urlString);
        Map<Object, Definition> map2 = this.definitionsMap;
        synchronized (map2) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition(String url) throws WSDLException {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
        }
        return this.loadDefinition(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition(Element el) throws WSDLException {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(el)) {
                return this.definitionsMap.get(el);
            }
        }
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(this.registry);
        Definition def = reader.readWSDL("", el);
        Map<Object, Definition> map2 = this.definitionsMap;
        synchronized (map2) {
            this.definitionsMap.put(el, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinition(Object key, Definition wsdl) {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            this.definitionsMap.put(key, wsdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition loadDefinition(String url) throws WSDLException {
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        reader.setExtensionRegistry(this.registry);
        CatalogWSDLLocator catLocator = new CatalogWSDLLocator(url, this.bus);
        ResourceManagerWSDLLocator wsdlLocator = new ResourceManagerWSDLLocator(url, catLocator, this.bus);
        InputSource src = wsdlLocator.getBaseInputSource();
        Definition def = null;
        if (src.getByteStream() != null || src.getCharacterStream() != null) {
            Document doc;
            XMLStreamReader xmlReader = null;
            try {
                xmlReader = StaxUtils.createXMLStreamReader((InputSource)src);
                doc = StaxUtils.read((XMLStreamReader)xmlReader, (boolean)true);
                if (src.getSystemId() != null) {
                    try {
                        doc.setDocumentURI(new String(src.getSystemId()));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                throw new WSDLException("PARSER_ERROR", e.getMessage(), (Throwable)e);
            }
            finally {
                StaxUtils.close((XMLStreamReader)xmlReader);
            }
            def = reader.readWSDL((WSDLLocator)wsdlLocator, doc.getDocumentElement());
        } else {
            def = reader.readWSDL((WSDLLocator)wsdlLocator);
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    private void registerInitialExtensions(Bus b) throws BusException {
        this.registerInitialXmlExtensions(EXTENSIONS_RESOURCE_COMPAT, b);
        this.registerInitialXmlExtensions(EXTENSIONS_RESOURCE, b);
    }

    private void registerInitialXmlExtensions(String resource, Bus b) throws BusException {
        Properties initialExtensions = null;
        try {
            ClassLoader cl = null;
            if (b != null) {
                cl = (ClassLoader)b.getExtension(ClassLoader.class);
            }
            if (cl != null) {
                initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)resource, (ClassLoader)cl);
            }
            if (initialExtensions == null || initialExtensions.size() == 0) {
                initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)resource, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
        }
        catch (IOException ex) {
            throw new BusException((Throwable)ex);
        }
        Iterator<Object> it = initialExtensions.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(initialExtensions.getProperty((String)it.next()), "=");
            String parentType = st.nextToken();
            String elementType = st.nextToken();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering extension: " + elementType + " for parent: " + parentType);
                }
                JAXBExtensionHelper.addExtensions((ExtensionRegistry)this.registry, (String)parentType, (String)elementType);
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
            catch (JAXBException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
    }

    private void addExtensionAttributeTypes(ExtensionRegistry extreg) {
        QName qn = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action");
        extreg.registerExtensionAttributeType(Input.class, qn, 0);
        extreg.registerExtensionAttributeType(Output.class, qn, 0);
        extreg.registerExtensionAttributeType(Fault.class, qn, 0);
        qn = new QName("http://www.w3.org/2007/05/addressing/metadata", "Action");
        extreg.registerExtensionAttributeType(Input.class, qn, 0);
        extreg.registerExtensionAttributeType(Output.class, qn, 0);
        extreg.registerExtensionAttributeType(Fault.class, qn, 0);
        qn = new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action");
        extreg.registerExtensionAttributeType(Input.class, qn, 0);
        extreg.registerExtensionAttributeType(Output.class, qn, 0);
        extreg.registerExtensionAttributeType(Fault.class, qn, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceSchemaInfo getSchemasForDefinition(Definition wsdl) {
        if (this.disableSchemaCache) {
            return null;
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            for (Map.Entry<Object, Definition> e : this.definitionsMap.entrySet()) {
                ServiceSchemaInfo info;
                if (e.getValue() != wsdl || (info = this.schemaCacheMap.get(e.getKey())) == null) continue;
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSchemasForDefinition(Definition wsdl, ServiceSchemaInfo schemas) {
        if (!this.disableSchemaCache) {
            Map<Object, Definition> map = this.definitionsMap;
            synchronized (map) {
                for (Map.Entry<Object, Definition> e : this.definitionsMap.entrySet()) {
                    if (e.getValue() != wsdl) continue;
                    this.schemaCacheMap.put(e.getKey(), schemas);
                }
            }
        }
    }

    public boolean isDisableSchemaCache() {
        return this.disableSchemaCache;
    }

    public void setDisableSchemaCache(boolean disableSchemaCache) {
        this.disableSchemaCache = disableSchemaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefinition(Definition wsdl) {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            ArrayList<Object> keys = new ArrayList<Object>();
            for (Map.Entry<Object, Definition> entry : this.definitionsMap.entrySet()) {
                if (entry.getValue() != wsdl) continue;
                keys.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : keys) {
                this.definitionsMap.remove(entry);
                this.schemaCacheMap.remove(entry);
            }
        }
    }
}

