/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientRequest;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class NettyHttpClientHandler
extends SimpleChannelHandler {
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HttpResponse response = (HttpResponse)e.getMessage();
        Channel ch = ctx.getChannel();
        BlockingQueue sendedQueue = (BlockingQueue)ch.getAttachment();
        NettyHttpClientRequest request = (NettyHttpClientRequest)sendedQueue.poll();
        request.setResponse(response);
        request.getCxfResponseCallback().responseReceived(response);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object p = e.getMessage();
        if (p instanceof NettyHttpClientRequest) {
            NettyHttpClientRequest request = (NettyHttpClientRequest)e.getMessage();
            Channel ch = ctx.getChannel();
            LinkedBlockingDeque<NettyHttpClientRequest> sendedQueue = (LinkedBlockingDeque<NettyHttpClientRequest>)ch.getAttachment();
            if (sendedQueue == null) {
                sendedQueue = new LinkedBlockingDeque<NettyHttpClientRequest>();
                ch.setAttachment(sendedQueue);
            }
            sendedQueue.put(request);
            ctx.getChannel().write((Object)request.getRequest());
        } else {
            super.writeRequested(ctx, e);
        }
    }
}

