/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import java.net.URI;
import org.apache.cxf.transport.http.netty.client.CxfResponseCallBack;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class NettyHttpClientRequest {
    private HttpRequest request;
    private HttpResponse response;
    private URI uri;
    private CxfResponseCallBack cxfResponseCallback;
    private int connectionTimeout;
    private int receiveTimeout;

    public NettyHttpClientRequest(URI requestUri, String method) {
        this.uri = requestUri;
        this.request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method), this.uri.getPath().toString());
        this.request.setHeader("Connection", (Object)"keep-alive");
        this.request.setHeader("Host", (Object)(this.uri.getHost() + ":" + this.uri.getPort()));
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setCxfResponseCallback(CxfResponseCallBack callback) {
        this.cxfResponseCallback = callback;
    }

    public CxfResponseCallBack getCxfResponseCallback() {
        return this.cxfResponseCallback;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setReceiveTimeout(int timeout) {
        this.receiveTimeout = timeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }
}

