/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http.netty.server.NettyHttpHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngine;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngineFactory;
import org.apache.cxf.transport.http.netty.server.ServerEngine;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.transports.http.StemMatchingQueryHandler;

public class NettyHttpDestination
extends AbstractHTTPDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpDestination.class);
    protected NettyHttpServerEngine engine;
    protected NettyHttpServerEngineFactory serverEngineFactory;
    protected ServletContext servletContext;
    protected ClassLoader loader;
    protected URL nurl;
    private boolean configFinalized;

    public NettyHttpDestination(Bus b, DestinationRegistry registry, EndpointInfo ei, NettyHttpServerEngineFactory serverEngineFactory) throws IOException {
        super(b, registry, ei, NettyHttpDestination.getAddressValue((EndpointInfo)ei, (boolean)true).getAddress(), true);
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        this.serverEngineFactory = serverEngineFactory;
        this.nurl = new URL(this.getAddress(this.endpointInfo));
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void retrieveEngine() throws IOException {
        this.engine = this.serverEngineFactory.retrieveNettyHttpServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.createNettyHttpServerEngine(this.nurl.getHost(), this.nurl.getPort(), this.nurl.getProtocol());
        }
        assert (this.engine != null);
    }

    public void finalizeConfig() {
        assert (!this.configFinalized);
        try {
            this.retrieveEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.configFinalized = true;
    }

    private String getAddress(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        if (address.startsWith("netty://")) {
            address = address.substring(8);
        }
        return address;
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.getAddress(this.endpointInfo)).getPath();
    }

    protected void activate() {
        super.activate();
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        URL url = null;
        try {
            url = new URL(this.getAddress(this.endpointInfo));
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        this.engine.addServant(url, new NettyHttpHandler(this, this.contextMatchOnExact()));
    }

    protected void deactivate() {
        super.deactivate();
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeServant(this.nurl);
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(this.servletContext, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (context == null) {
            context = this.servletContext;
        }
        if (this.getServer().isSetRedirectURL()) {
            resp.sendRedirect(this.getServer().getRedirectURL());
            resp.flushBuffer();
            return;
        }
        QueryHandlerRegistry queryHandlerRegistry = (QueryHandlerRegistry)this.bus.getExtension(QueryHandlerRegistry.class);
        if (null != req.getQueryString() && queryHandlerRegistry != null) {
            String reqAddr = req.getRequestURL().toString();
            String requestURL = reqAddr + "?" + req.getQueryString();
            String pathInfo = req.getPathInfo();
            for (QueryHandler qh : queryHandlerRegistry.getHandlers()) {
                boolean recognized = qh instanceof StemMatchingQueryHandler ? ((StemMatchingQueryHandler)qh).isRecognizedQuery(requestURL, pathInfo, this.endpointInfo, this.contextMatchOnExact()) : qh.isRecognizedQuery(requestURL, pathInfo, this.endpointInfo);
                if (!recognized) continue;
                String errorMsg = null;
                CachedOutputStream out = new CachedOutputStream();
                try {
                    EndpointInfo endpointInfo = this.endpointInfo;
                    synchronized (endpointInfo) {
                        String oldAddress = this.updateEndpointAddress(reqAddr);
                        resp.setContentType(qh.getResponseContentType(requestURL, pathInfo));
                        try {
                            qh.writeResponse(requestURL, pathInfo, this.endpointInfo, (OutputStream)out);
                        }
                        catch (Exception ex) {
                            LOG.log(Level.WARNING, "writeResponse failed: ", ex);
                            errorMsg = ex.getMessage();
                        }
                        this.endpointInfo.setAddress(oldAddress);
                    }
                    if (errorMsg != null) {
                        resp.sendError(500, errorMsg);
                    } else {
                        out.writeCacheTo((OutputStream)resp.getOutputStream());
                        resp.getOutputStream().flush();
                    }
                }
                finally {
                    out.close();
                }
                return;
            }
        }
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            this.serviceRequest(context, req, resp);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    protected void serviceRequest(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Message inMessage;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        if ((inMessage = this.retrieveFromContinuation(req)) == null) {
            inMessage = new MessageImpl();
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.setInMessage(inMessage);
            this.setupMessage(inMessage, context, req, resp);
            ((MessageImpl)inMessage).setDestination((Destination)this);
            exchange.setSession((Session)new HTTPSession(req));
        }
        try {
            this.incomingObserver.onMessage(inMessage);
            resp.flushBuffer();
        }
        catch (SuspendedInvocationException ex) {
            if (ex.getRuntimeException() != null) {
                throw ex.getRuntimeException();
            }
        }
        catch (Fault ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    public ServerEngine getEngine() {
        return this.engine;
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        return (Message)req.getAttribute("cxf.continuation.message");
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
    }

    private synchronized String updateEndpointAddress(String addr) {
        String address = this.removeTrailingSeparator(this.endpointInfo.getAddress());
        if (this.getBasePathForFullAddress(address).equals(this.removeTrailingSeparator(this.getStem(this.getBasePathForFullAddress(addr))))) {
            this.endpointInfo.setAddress(addr);
        }
        return address;
    }

    private String removeTrailingSeparator(String addr) {
        if (addr != null && addr.length() > 0 && addr.lastIndexOf(47) == addr.length() - 1) {
            return addr.substring(0, addr.length() - 1);
        }
        return addr;
    }

    protected String getBasePathForFullAddress(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String getStem(String baseURI) {
        return baseURI.substring(0, baseURI.lastIndexOf("/"));
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

