/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.bus.BusState;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.bus.managers.BindingFactoryManagerImpl;
import org.apache.cxf.bus.managers.ConduitInitiatorManagerImpl;
import org.apache.cxf.bus.managers.DestinationFactoryManagerImpl;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.NullConfigurer;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ObjectTypeResolver;
import org.apache.cxf.resource.PropertiesResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.resource.SinglePropertyResolver;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactoryManager;

public class ExtensionManagerBus
extends CXFBusImpl {
    public static final String BUS_PROPERTY_NAME = "bus";
    private static final String BUS_ID_PROPERTY_NAME = "org.apache.cxf.bus.id";
    private final ExtensionManagerImpl extensionManager;

    public ExtensionManagerBus(Map<Class<?>, Object> e, Map<String, Object> properties, ClassLoader extensionClassLoader) {
        super(e);
        Configurer configurer;
        if (null == properties) {
            properties = new HashMap<String, Object>();
        }
        if (null == (configurer = (Configurer)this.extensions.get(Configurer.class))) {
            configurer = new NullConfigurer();
            this.extensions.put(Configurer.class, configurer);
        }
        this.setId(this.getBusId(properties));
        DefaultResourceManager resourceManager = new DefaultResourceManager();
        properties.put(BUS_ID_PROPERTY_NAME, BUS_PROPERTY_NAME);
        properties.put(BUS_PROPERTY_NAME, this);
        properties.put("cxf", this);
        PropertiesResolver propertiesResolver = new PropertiesResolver(properties);
        resourceManager.addResourceResolver(propertiesResolver);
        SinglePropertyResolver busResolver = new SinglePropertyResolver(BUS_PROPERTY_NAME, this);
        resourceManager.addResourceResolver(busResolver);
        resourceManager.addResourceResolver(new ObjectTypeResolver(this));
        busResolver = new SinglePropertyResolver("cxf", this);
        resourceManager.addResourceResolver(busResolver);
        resourceManager.addResourceResolver(new ObjectTypeResolver(this));
        resourceManager.addResourceResolver(new ResourceResolver(){

            @Override
            public <T> T resolve(String resourceName, Class<T> resourceType) {
                if (ExtensionManagerBus.this.extensionManager != null) {
                    return ExtensionManagerBus.this.extensionManager.getExtension(resourceName, resourceType);
                }
                return null;
            }

            @Override
            public InputStream getAsStream(String name) {
                return null;
            }
        });
        this.extensions.put(ResourceManager.class, resourceManager);
        this.extensionManager = new ExtensionManagerImpl(new String[0], extensionClassLoader, this.extensions, (ResourceManager)resourceManager, (Bus)this);
        this.setState(BusState.INITIAL);
        if (null == this.getExtension(DestinationFactoryManager.class)) {
            new DestinationFactoryManagerImpl(this);
        }
        if (null == this.getExtension(ConduitInitiatorManager.class)) {
            new ConduitInitiatorManagerImpl(this);
        }
        if (null == this.getExtension(BindingFactoryManager.class)) {
            new BindingFactoryManagerImpl(this);
        }
        this.extensionManager.load(new String[]{"META-INF/cxf/bus-extensions.txt", "META-INF/cxf/bus-extensions.xml", "bus-extensions.xml"});
        this.extensionManager.activateAllByType(ResourceResolver.class);
        this.setExtension(this.extensionManager, ExtensionManager.class);
    }

    public ExtensionManagerBus(Map<Class<?>, Object> e, Map<String, Object> properties) {
        this(e, properties, Thread.currentThread().getContextClassLoader());
    }

    public ExtensionManagerBus() {
        this(null, null, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void doInitializeInternal() {
        this.extensionManager.initialize();
        super.doInitializeInternal();
    }

    @Override
    protected void destroyBeans() {
        this.extensionManager.destroyBeans();
    }

    @Override
    protected synchronized ConfiguredBeanLocator createConfiguredBeanLocator() {
        ConfiguredBeanLocator loc = (ConfiguredBeanLocator)this.extensions.get(ConfiguredBeanLocator.class);
        if (loc == null) {
            loc = this.extensionManager;
            this.setExtension(loc, ConfiguredBeanLocator.class);
        }
        return loc;
    }

    private String getBusId(Map<String, Object> properties) {
        String busId = null;
        if (null != properties && null != (busId = (String)properties.get(BUS_ID_PROPERTY_NAME)) && !"".equals(busId)) {
            return busId;
        }
        busId = SystemPropertyAction.getPropertyOrNull(BUS_ID_PROPERTY_NAME);
        if (null != busId && !"".equals(busId)) {
            return busId;
        }
        return null;
    }
}

